/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.fueler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.gegy1000.psf.server.block.PSFBlockRegistry;
import net.gegy1000.psf.server.capability.CapabilityModule;
import net.gegy1000.psf.server.fluid.PSFFluidRegistry;
import net.gegy1000.psf.server.util.ContiguousBlockIterator;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

@ParametersAreNonnullByDefault
public class TileFuelLoader
extends TileEntity {
    private final IItemHandler inventory = new ItemStackHandler(NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a)){

        protected void onContentsChanged(int slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (!stack.func_190926_b() && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                IFluidTankProperties[] tankProperties;
                IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (handler == null) {
                    return;
                }
                for (IFluidTankProperties properties : tankProperties = handler.getTankProperties()) {
                    int filled;
                    FluidStack contents = properties.getContents();
                    if (contents == null) continue;
                    if (TileFuelLoader.this.fluidHandler == null) {
                        TileFuelLoader.this.rebuildTankList();
                    }
                    if ((filled = TileFuelLoader.this.fluidHandler.fill(handler.drain(contents, true), true)) < contents.amount) {
                        handler.fill(new FluidStack(contents.getFluid(), filled), true);
                    }
                    this.stacks.set(slot, (Object)handler.getContainer());
                }
            }
        }
    };
    private IFluidHandler fluidHandler = null;

    public void rebuildTankList() {
        EnumFacing facing = (EnumFacing)PSFBlockRegistry.fuelLoader.func_176203_a(this.func_145832_p()).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        HashSet<IFluidHandler> handlers = new HashSet<IFluidHandler>();
        BlockPos origin = this.func_174877_v().func_177972_a(facing);
        Iterator<BlockPos> tankIterator = this.getContiguousTankIterator(origin);
        while (tankIterator.hasNext()) {
            BlockPos pos = tankIterator.next();
            IFluidHandler fuelTank = this.getFuelTank(pos);
            if (fuelTank == null) continue;
            handlers.add(fuelTank);
        }
        this.fluidHandler = new FluidHandlerConcatenate(handlers);
    }

    public Map<Fluid, FuelAmount> collectFuelAmounts() {
        HashMap<Fluid, FuelAmount> amounts = new HashMap<Fluid, FuelAmount>();
        if (this.fluidHandler != null) {
            IFluidTankProperties[] tankProperties;
            for (IFluidTankProperties tank : tankProperties = this.fluidHandler.getTankProperties()) {
                FuelAmount amount;
                FluidStack contents = tank.getContents();
                if (contents == null) continue;
                FuelAmount fuelAmount = amount = amounts.computeIfAbsent(contents.getFluid(), fluid -> new FuelAmount());
                fuelAmount.amount = fuelAmount.amount + contents.amount;
                fuelAmount = amount;
                fuelAmount.capacity = fuelAmount.capacity + tank.getCapacity();
            }
        }
        return amounts;
    }

    private Iterator<BlockPos> getContiguousTankIterator(BlockPos origin) {
        return new ContiguousBlockIterator(origin, 32, pos -> this.getFuelTank((BlockPos)pos) != null);
    }

    @Nullable
    private IFluidHandler getFuelTank(BlockPos pos) {
        TileEntity entity = this.field_145850_b.func_175625_s(pos);
        if (entity != null && entity.hasCapability(CapabilityModule.INSTANCE, null) && entity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            IFluidTankProperties[] tankProperties;
            IFluidHandler fluidHandler = (IFluidHandler)entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
                FluidStack contents = properties.getContents();
                if (!this.isAcceptableFluid(contents)) continue;
                return fluidHandler;
            }
        }
        return null;
    }

    private boolean isAcceptableFluid(@Nullable FluidStack stack) {
        return stack != null && (stack.getFluid() == PSFFluidRegistry.KEROSENE || stack.getFluid() == PSFFluidRegistry.LIQUID_OXYGEN);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.fluidHandler == null) {
                this.rebuildTankList();
            }
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public static class FuelAmount {
        private int amount;
        private int capacity;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FuelAmount)) {
                return false;
            }
            FuelAmount other = (FuelAmount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAmount() != other.getAmount()) {
                return false;
            }
            return this.getCapacity() == other.getCapacity();
        }

        protected boolean canEqual(Object other) {
            return other instanceof FuelAmount;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAmount();
            result = result * 59 + this.getCapacity();
            return result;
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public void setCapacity(int capacity) {
            this.capacity = capacity;
        }
    }
}

