/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.fueler;

import java.util.ArrayList;
import net.gegy1000.psf.server.block.PSFBlockRegistry;
import net.gegy1000.psf.server.block.fueler.ContainerFuelLoader;
import net.gegy1000.psf.server.block.fueler.TileFuelLoader;
import net.gegy1000.psf.server.fluid.PSFFluidRegistry;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class GuiFuelLoader
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("psf", "textures/gui/fuel_loader.png");
    private static final boolean SCISSOR_AVAILABLE = GLContext.getCapabilities().OpenGL20;
    private static final int TANK_WIDTH = 20;
    private static final int TANK_HEIGHT = 63;
    private final ContainerFuelLoader container;

    public GuiFuelLoader(ContainerFuelLoader container) {
        super((Container)container);
        this.container = container;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        int originX = (this.field_146294_l - this.field_146999_f) / 2;
        int originY = (this.field_146295_m - this.field_147000_g) / 2;
        mouseX -= originX;
        mouseY -= originY;
        String title = I18n.func_135052_a((String)(PSFBlockRegistry.fuelLoader.func_149739_a() + ".name"), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(title, (this.field_146999_f - this.field_146289_q.func_78256_a(title)) / 2, 4, 0x404040);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TileFuelLoader.FuelAmount keroseneAmount = this.container.getKeroseneAmount();
        TileFuelLoader.FuelAmount liquidOxygenAmount = this.container.getLiquidOxygenAmount();
        this.drawTank(PSFFluidRegistry.KEROSENE, keroseneAmount.getAmount(), keroseneAmount.getCapacity(), 61, 13);
        this.drawTank(PSFFluidRegistry.LIQUID_OXYGEN, liquidOxygenAmount.getAmount(), liquidOxygenAmount.getCapacity(), 91, 13);
        this.drawTankTooltip(PSFFluidRegistry.KEROSENE, keroseneAmount.getAmount(), keroseneAmount.getCapacity(), 61, 13, mouseX, mouseY);
        this.drawTankTooltip(PSFFluidRegistry.LIQUID_OXYGEN, liquidOxygenAmount.getAmount(), liquidOxygenAmount.getCapacity(), 91, 13, mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int originX = (this.field_146294_l - this.field_146999_f) / 2;
        int originY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(originX, originY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    private void drawTank(Fluid fluid, int amount, int capacity, int x, int y) {
        GlStateManager.func_179147_l();
        TextureAtlasSprite sprite = this.field_146297_k.func_147117_R().func_110572_b(fluid.getStill().toString());
        float scale = (float)amount / (float)capacity;
        int height = (int)(scale * 63.0f);
        this.drawSpriteTiled(sprite, x + 1, y + 1 + (63 - height), 20, height);
        GlStateManager.func_179084_k();
    }

    private void drawTankTooltip(Fluid fluid, int amount, int capacity, int x, int y, int mouseX, int mouseY) {
        if (mouseX >= x && mouseY >= y && mouseX <= x + 20 && mouseY <= y + 63) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(fluid.getRarity().field_77937_e + I18n.func_135052_a((String)fluid.getUnlocalizedName(), (Object[])new Object[0]));
            lines.add(TextFormatting.BLUE.toString() + amount + "/" + capacity);
            float percentage = capacity == 0 ? 0.0f : (float)amount / (float)capacity * 100.0f;
            lines.add(TextFormatting.GRAY.toString() + TextFormatting.ITALIC + String.format("%.1f%%", Float.valueOf(percentage)));
            GuiUtils.drawHoveringText(lines, (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)100, (FontRenderer)this.field_146289_q);
        }
    }

    private void drawSpriteTiled(TextureAtlasSprite sprite, int x, int y, int width, int height) {
        if (SCISSOR_AVAILABLE) {
            ScaledResolution resolution = new ScaledResolution(this.field_146297_k);
            GL11.glEnable((int)3089);
            GL11.glScissor((int)((this.field_147003_i + x) * resolution.func_78325_e()), (int)(this.field_146297_k.field_71440_d - (this.field_147009_r + y + height) * resolution.func_78325_e()), (int)(width * resolution.func_78325_e()), (int)(height * resolution.func_78325_e()));
        }
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        int textureSize = 16;
        int countX = (int)Math.ceil((float)width / (float)textureSize);
        int countY = (int)Math.ceil((float)height / (float)textureSize);
        int originX = x + (width - countX * textureSize) / 2;
        int originY = y + (height - countY * textureSize) / 2;
        for (int spriteY = 0; spriteY < countY; ++spriteY) {
            for (int spriteX = 0; spriteX < countX; ++spriteX) {
                this.func_175175_a(originX + spriteX * textureSize, originY + spriteY * textureSize, sprite, 16, 16);
            }
        }
        if (SCISSOR_AVAILABLE) {
            GL11.glDisable((int)3089);
        }
    }
}

