/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.fueler;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.gegy1000.psf.server.block.fueler.SlotFluidContainer;
import net.gegy1000.psf.server.block.fueler.TileFuelLoader;
import net.gegy1000.psf.server.fluid.PSFFluidRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@ParametersAreNonnullByDefault
public class ContainerFuelLoader
extends Container {
    public static final int KEROSENE_AMOUNT = 0;
    public static final int KEROSENE_CAPACITY = 1;
    public static final int LIQUID_OXYGEN_AMOUNT = 2;
    public static final int LIQUID_OXYGEN_CAPACITY = 3;
    private static final int PLAYER_INVENTORY_SIZE = 36;
    private final TileFuelLoader entity;
    private TileFuelLoader.FuelAmount keroseneAmount = new TileFuelLoader.FuelAmount();
    private TileFuelLoader.FuelAmount liquidOxygenAmount = new TileFuelLoader.FuelAmount();

    public ContainerFuelLoader(TileFuelLoader entity, InventoryPlayer playerInventory) {
        this.entity = entity;
        IItemHandler itemHandler = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.func_75146_a((Slot)new SlotFluidContainer(itemHandler, 0, 26, 36, PSFFluidRegistry.KEROSENE));
        this.func_75146_a((Slot)new SlotFluidContainer(itemHandler, 1, 134, 36, PSFFluidRegistry.LIQUID_OXYGEN));
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.func_75146_a(new Slot((IInventory)playerInventory, column + row * 9 + 9, 8 + column * 18, 84 + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.func_75146_a(new Slot((IInventory)playerInventory, column, 8 + column * 18, 142));
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        Map<Fluid, TileFuelLoader.FuelAmount> fuelAmounts = this.entity.collectFuelAmounts();
        TileFuelLoader.FuelAmount keroseneAmount = fuelAmounts.getOrDefault(PSFFluidRegistry.KEROSENE, new TileFuelLoader.FuelAmount());
        TileFuelLoader.FuelAmount liquidOxygenAmount = fuelAmounts.getOrDefault(PSFFluidRegistry.LIQUID_OXYGEN, new TileFuelLoader.FuelAmount());
        boolean keroseneChanged = !this.keroseneAmount.equals(keroseneAmount);
        boolean liquidOxygenChanged = !this.liquidOxygenAmount.equals(liquidOxygenAmount);
        for (IContainerListener listener : this.field_75149_d) {
            if (keroseneChanged) {
                listener.func_71112_a((Container)this, 0, keroseneAmount.getAmount());
                listener.func_71112_a((Container)this, 1, keroseneAmount.getCapacity());
            }
            if (!liquidOxygenChanged) continue;
            listener.func_71112_a((Container)this, 2, liquidOxygenAmount.getAmount());
            listener.func_71112_a((Container)this, 3, liquidOxygenAmount.getCapacity());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        super.func_75137_b(id, data);
        if (this.keroseneAmount == null) {
            this.keroseneAmount = new TileFuelLoader.FuelAmount();
        }
        if (this.liquidOxygenAmount == null) {
            this.liquidOxygenAmount = new TileFuelLoader.FuelAmount();
        }
        switch (id) {
            case 0: {
                this.keroseneAmount.setAmount(data);
                break;
            }
            case 1: {
                this.keroseneAmount.setCapacity(data);
                break;
            }
            case 2: {
                this.liquidOxygenAmount.setAmount(data);
                break;
            }
            case 3: {
                this.liquidOxygenAmount.setCapacity(data);
            }
        }
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack transferred = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        int otherSlots = this.field_75151_b.size() - 36;
        if (slot != null && slot.func_75216_d()) {
            ItemStack current = slot.func_75211_c();
            ItemStack copy = current.func_77946_l();
            transferred = current.func_77946_l();
            if (index < otherSlots) {
                if (!this.func_75135_a(copy, otherSlots, this.field_75151_b.size(), false)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75218_e();
            } else if (!this.func_75135_a(copy, 0, otherSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (copy.func_190916_E() == 0) {
                slot.func_190901_a(player, copy);
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return transferred;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return player.func_174831_c(this.entity.func_174877_v()) < 64.0;
    }

    public TileFuelLoader.FuelAmount getKeroseneAmount() {
        return this.keroseneAmount;
    }

    public TileFuelLoader.FuelAmount getLiquidOxygenAmount() {
        return this.liquidOxygenAmount;
    }
}

