/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.controller;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.psf.PracticalSpaceFireworks;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.api.IModuleFactory;
import net.gegy1000.psf.api.ISatellite;
import net.gegy1000.psf.api.data.IModuleData;
import net.gegy1000.psf.server.capability.CapabilityController;
import net.gegy1000.psf.server.capability.CapabilityModule;
import net.gegy1000.psf.server.capability.CapabilitySatellite;
import net.gegy1000.psf.server.modules.ModuleController;
import net.gegy1000.psf.server.modules.Modules;
import net.gegy1000.psf.server.satellite.TileBoundSatellite;
import net.gegy1000.psf.server.util.ContiguousBlockIterator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;

public class TileController
extends TileEntity
implements ITickable {
    private final ISatellite satellite = new TileBoundSatellite(this);
    private final ModuleController controller = (ModuleController)((IModuleFactory)Modules.get().getValue(new ResourceLocation("psf", "controller_simple"))).get();
    private long lastScanTime = Long.MIN_VALUE;
    private boolean converted;
    private Map<BlockPos, ScanValue> modules = Collections.emptyMap();
    public static final int CONTIGUOUS_RANGE = 32;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.satellite.tickSatellite(this.func_145831_w().func_82737_E());
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!this.func_145831_w().field_72995_K) {
            PracticalSpaceFireworks.PROXY.getSatellites().register(this.satellite);
        }
        this.controller.setPos(this.func_174877_v());
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.unregister();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.unregister();
    }

    private void unregister() {
        if (!this.func_145831_w().field_72995_K && !this.converted) {
            PracticalSpaceFireworks.PROXY.getSatellites().remove(this.satellite);
        }
    }

    public void converted() {
        this.converted = true;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilitySatellite.INSTANCE || capability == CapabilityController.INSTANCE || capability == CapabilityModule.INSTANCE || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilitySatellite.INSTANCE) {
            return (T)CapabilitySatellite.INSTANCE.cast((Object)this.satellite);
        }
        if (capability == CapabilityController.INSTANCE) {
            return (T)CapabilityController.INSTANCE.cast((Object)this.controller);
        }
        if (capability == CapabilityModule.INSTANCE) {
            return (T)CapabilityModule.INSTANCE.cast((Object)this.controller);
        }
        return (T)super.getCapability(capability, facing);
    }

    public Map<BlockPos, ScanValue> getModules() {
        if (this.lastScanTime + 20L <= this.func_145831_w().func_82737_E()) {
            this.modules = this.scanStructure();
            this.lastScanTime = this.func_145831_w().func_82737_E();
        }
        return this.modules;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("satellite_data", (NBTBase)this.satellite.serializeNBT());
        compound.func_74782_a("module_data", (NBTBase)this.controller.serializeNBT());
        return compound;
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.satellite.deserializeNBT(compound.func_74775_l("satellite_data"));
        this.controller.deserializeNBT(compound.func_74775_l("module_data"));
    }

    public Map<BlockPos, ScanValue> scanStructure() {
        Iterator<BlockPos> modules = this.getContiguousIterator(this.func_174877_v());
        HashMap<BlockPos, ScanValue> ret = new HashMap<BlockPos, ScanValue>();
        while (modules.hasNext()) {
            BlockPos pos = modules.next();
            TileEntity te = this.func_145831_w().func_175625_s(pos);
            if (te == null || !te.hasCapability(CapabilityModule.INSTANCE, null)) continue;
            IModule module = (IModule)te.getCapability(CapabilityModule.INSTANCE, null);
            ret.put(pos, new ScanValue(this.func_145831_w().func_180495_p(pos), module));
        }
        ret.put(this.func_174877_v(), new ScanValue(this.func_145831_w().func_180495_p(this.func_174877_v()), this.controller));
        return ret;
    }

    private Iterator<BlockPos> getContiguousIterator(@Nonnull BlockPos origin) {
        return new ContiguousBlockIterator(origin, 32, pos -> {
            TileEntity entity = this.field_145850_b.func_175625_s(pos);
            return entity != null && entity.hasCapability(CapabilityModule.INSTANCE, null);
        });
    }

    public final class ScanValue {
        private final IBlockState state;
        private final IModule module;

        public ScanValue(IBlockState state, IModule module) {
            this.state = state;
            this.module = module;
        }

        public IBlockState getState() {
            return this.state;
        }

        public IModule getModule() {
            return this.module;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScanValue)) {
                return false;
            }
            ScanValue other = (ScanValue)o;
            IBlockState this$state = this.getState();
            IBlockState other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            IModule this$module = this.getModule();
            IModule other$module = other.getModule();
            return !(this$module == null ? other$module != null : !this$module.equals(other$module));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IBlockState $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            IModule $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            return result;
        }

        public String toString() {
            return "TileController.ScanValue(state=" + this.getState() + ", module=" + this.getModule() + ")";
        }
    }

    private static interface Exclusions {
        public <T extends IModuleData> Collection<T> getConnectedCaps(ISatellite var1, Capability<T> var2);
    }
}

