/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block.controller;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.psf.PracticalSpaceFireworks;
import net.gegy1000.psf.api.ISatellite;
import net.gegy1000.psf.server.api.RegisterItemBlock;
import net.gegy1000.psf.server.api.RegisterItemModel;
import net.gegy1000.psf.server.api.RegisterTileEntity;
import net.gegy1000.psf.server.block.controller.ControllerType;
import net.gegy1000.psf.server.block.controller.TileController;
import net.gegy1000.psf.server.block.module.BlockModule;
import net.gegy1000.psf.server.block.remote.packet.PacketCraftState;
import net.gegy1000.psf.server.block.remote.packet.PacketOpenRemoteControl;
import net.gegy1000.psf.server.capability.CapabilitySatellite;
import net.gegy1000.psf.server.entity.spacecraft.EntitySpacecraft;
import net.gegy1000.psf.server.network.PSFNetworkHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockController
extends Block
implements RegisterItemBlock,
RegisterItemModel,
RegisterTileEntity {
    @Nonnull
    public static final IProperty<ControllerType> TYPE = PropertyEnum.func_177709_a((String)"type", ControllerType.class);
    @Nonnull
    public static final IProperty<EnumFacing> DIRECTION = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);
    private final ControllerType type;

    public BlockController(ControllerType type) {
        super(Material.field_151573_f);
        this.type = type;
        this.func_149647_a(PracticalSpaceFireworks.TAB);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, DIRECTION});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_180639_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileController) {
            ISatellite satellite = (ISatellite)te.getCapability(CapabilitySatellite.INSTANCE, null);
            if (!worldIn.field_72995_K) {
                Map<BlockPos, TileController.ScanValue> modules = ((TileController)te).scanStructure();
                EntitySpacecraft spacecraft = new EntitySpacecraft(worldIn, modules.keySet(), pos, satellite.getId());
                ISatellite newsat = spacecraft.getCapability(CapabilitySatellite.INSTANCE, null);
                newsat.setName(satellite.getName());
                satellite.getTrackingPlayers().forEach(newsat::track);
                ((TileController)te).converted();
                BlockModule.CONVERTING.set(true);
                try {
                    modules.keySet().forEach(p -> worldIn.func_180501_a(p, Blocks.field_150350_a.func_176223_P(), 10));
                }
                finally {
                    BlockModule.CONVERTING.set(false);
                }
                spacecraft.func_70080_a((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 180.0f, 0.0f);
                worldIn.func_72838_d((Entity)spacecraft);
                for (EntityPlayerMP player : newsat.getTrackingPlayers()) {
                    PSFNetworkHandler.network.sendTo((IMessage)new PacketCraftState(PacketOpenRemoteControl.SatelliteState.ORBIT, newsat.toListedCraft()), player);
                }
            }
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, @Nonnull EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a(DIRECTION, (Comparable)facing);
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileController();
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((EnumFacing)state.func_177229_b(DIRECTION)).ordinal();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        meta = Math.abs(meta) % EnumFacing.values().length;
        return this.func_176223_P().func_177226_a(DIRECTION, (Comparable)EnumFacing.values()[meta]);
    }

    @Override
    public Class<? extends TileEntity> getEntityClass() {
        return TileController.class;
    }
}

