/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server.block;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.gegy1000.psf.PracticalSpaceFireworks;
import net.gegy1000.psf.server.api.RegisterItemBlock;
import net.gegy1000.psf.server.api.RegisterTileEntity;
import net.gegy1000.psf.server.block.BlockPSFFluid;
import net.gegy1000.psf.server.block.controller.BlockController;
import net.gegy1000.psf.server.block.controller.ControllerType;
import net.gegy1000.psf.server.block.fueler.BlockFuelLoader;
import net.gegy1000.psf.server.block.module.BlockBattery;
import net.gegy1000.psf.server.block.module.BlockFuelTank;
import net.gegy1000.psf.server.block.module.BlockModule;
import net.gegy1000.psf.server.block.module.BlockMultiblockModule;
import net.gegy1000.psf.server.block.module.BlockPayloadSeparator;
import net.gegy1000.psf.server.block.module.BlockStrut;
import net.gegy1000.psf.server.block.module.TileDummyModule;
import net.gegy1000.psf.server.block.module.TileModule;
import net.gegy1000.psf.server.block.remote.BlockRemoteControlSystem;
import net.gegy1000.psf.server.fluid.PSFFluidRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod.EventBusSubscriber(modid="psf")
public class PSFBlockRegistry {
    private static final Set<Block> REGISTERED_BLOCKS = new LinkedHashSet<Block>();
    private static final Set<ItemBlock> REGISTERED_ITEM_BLOCKS = new LinkedHashSet<ItemBlock>();
    public static BlockFluidFinite kerosene;
    public static BlockFluidFinite liquidOxygen;
    public static BlockStrut strut;
    public static BlockController basicController;
    public static BlockModule thruster;
    public static BlockRemoteControlSystem remoteControlSystem;
    public static BlockFuelLoader fuelLoader;
    public static BlockFuelTank fuelTank;
    public static BlockPayloadSeparator payloadSeparator;
    public static BlockMultiblockModule solarPanel;
    public static BlockMultiblockModule laser;

    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        basicController = new BlockController(ControllerType.BASIC);
        PSFBlockRegistry.register(event, "controller.simple", basicController);
        strut = PSFBlockRegistry.register(event, "strut", new BlockStrut());
        PSFBlockRegistry.register(event, "battery.simple", new BlockBattery("battery_simple"));
        thruster = PSFBlockRegistry.register(event, "thruster.simple", new BlockModule(Material.field_151573_f, "thruster_simple"){

            @Override
            protected boolean canAttachOnSide(IBlockState state, IBlockState on, EnumFacing side) {
                return side == EnumFacing.DOWN;
            }
        });
        PSFBlockRegistry.registerModuleBlock(event, "entity_detector.simple");
        PSFBlockRegistry.registerModuleBlock(event, "entity_marker");
        fuelTank = PSFBlockRegistry.register(event, "fuel_tank", new BlockFuelTank());
        payloadSeparator = PSFBlockRegistry.register(event, "payload_separator", new BlockPayloadSeparator());
        PSFBlockRegistry.registerModuleBlock(event, "terrain_scanner");
        solarPanel = PSFBlockRegistry.register(event, "solar_panel", new BlockMultiblockModule(Material.field_151573_f, "solar_panel"));
        laser = PSFBlockRegistry.register(event, "laser", new BlockMultiblockModule(Material.field_151573_f, "laser"){

            @Override
            protected int getHeight() {
                return 2;
            }
        });
        kerosene = PSFBlockRegistry.register(event, "kerosene", new BlockPSFFluid(PSFFluidRegistry.KEROSENE, Material.field_151586_h));
        liquidOxygen = PSFBlockRegistry.register(event, "liquid_oxygen", new BlockPSFFluid(PSFFluidRegistry.LIQUID_OXYGEN, Material.field_151586_h));
        remoteControlSystem = PSFBlockRegistry.register(event, "remote_control_system", new BlockRemoteControlSystem());
        fuelLoader = PSFBlockRegistry.register(event, "fuel_loader", new BlockFuelLoader());
        GameRegistry.registerTileEntity(TileModule.class, (String)"psf:module");
        GameRegistry.registerTileEntity(TileDummyModule.class, (String)"psf:dummy_module");
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        for (Block block : REGISTERED_BLOCKS) {
            if (!(block instanceof RegisterItemBlock)) continue;
            if (block.getRegistryName() == null) {
                PracticalSpaceFireworks.LOGGER.warn("Tried to register ItemBlock for block without registry name!");
                continue;
            }
            ItemBlock itemBlock = ((RegisterItemBlock)block).createItemBlock(block);
            event.getRegistry().register(itemBlock.setRegistryName(block.getRegistryName()));
        }
    }

    private static BlockModule registerModuleBlock(RegistryEvent.Register<Block> event, @Nonnull String identifier) {
        return PSFBlockRegistry.registerModuleBlock(event, Material.field_151573_f, identifier);
    }

    private static BlockModule registerModuleBlock(RegistryEvent.Register<Block> event, Material material, @Nonnull String identifier) {
        return PSFBlockRegistry.register(event, identifier, new BlockModule(material, identifier.replace('.', '_')));
    }

    private static <T extends Block> T register(RegistryEvent.Register<Block> event, @Nonnull String identifier, T block) {
        event.getRegistry().register(block.setRegistryName(new ResourceLocation("psf", identifier.replace('.', '_'))));
        block.func_149663_c("psf." + identifier);
        REGISTERED_BLOCKS.add(block);
        if (block instanceof RegisterTileEntity) {
            String blockEntityKey = "psf." + identifier;
            GameRegistry.registerTileEntity(((RegisterTileEntity)block).getEntityClass(), (String)blockEntityKey);
        }
        return block;
    }

    public static Set<Block> getRegisteredBlocks() {
        return Collections.unmodifiableSet(REGISTERED_BLOCKS);
    }

    public static Set<ItemBlock> getRegisteredItemBlocks() {
        return Collections.unmodifiableSet(REGISTERED_ITEM_BLOCKS);
    }
}

