/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.server;

import java.util.Collection;
import java.util.List;
import net.gegy1000.psf.api.ISatellite;
import net.gegy1000.psf.server.capability.world.CapabilityWorldData;
import net.gegy1000.psf.server.capability.world.SatelliteWorldData;
import net.gegy1000.psf.server.entity.spacecraft.EntitySpacecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="psf")
public class ServerEventHandler {
    @SubscribeEvent
    public static void onAttachWorldCapabilities(AttachCapabilitiesEvent<World> event) {
        event.addCapability(CapabilityWorldData.SATELLITE_ID, (ICapabilityProvider)new SatelliteWorldData.Impl((World)event.getObject()));
    }

    @SubscribeEvent
    public static void onWorldUpdate(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.world.field_72995_K && event.world.hasCapability(CapabilityWorldData.SATELLITE_INSTANCE, null)) {
            Collection<ISatellite> satellites = ((SatelliteWorldData)event.world.getCapability(CapabilityWorldData.SATELLITE_INSTANCE, null)).getSatellites();
            satellites.forEach(satellite -> satellite.tickSatellite(event.world.func_82737_E()));
        }
    }

    @SubscribeEvent
    public static void onCollide(GetCollisionBoxesEvent event) {
        Entity entity = event.getEntity();
        if (entity != null) {
            World world = entity.func_130014_f_();
            int radius = 32;
            AxisAlignedBB searchBounds = event.getAabb().func_72321_a((double)radius, (double)radius, (double)radius);
            List spacecrafts = world.func_72872_a(EntitySpacecraft.class, searchBounds);
            for (EntitySpacecraft spacecraft : spacecrafts) {
                if (!event.getAabb().func_72326_a(spacecraft.func_174813_aQ())) continue;
                spacecraft.collectTransformedBlockBounds(event.getAabb(), event.getCollisionBoxesList());
            }
        }
    }
}

