/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.client.render.spacecraft.model;

import java.util.EnumMap;
import java.util.Map;
import net.gegy1000.psf.client.render.spacecraft.model.SpacecraftModel;
import net.gegy1000.psf.server.entity.spacecraft.SpacecraftBlockAccess;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class VboSpacecraftModel
implements SpacecraftModel {
    private static final BlockRendererDispatcher BLOCK_RENDERER = Minecraft.func_71410_x().func_175602_ab();
    private static final BufferBuilder BUILDER = new BufferBuilder(131072);
    private final SpacecraftBlockAccess renderWorld;
    private final Map<BlockRenderLayer, VertexBuffer> buffers = new EnumMap<BlockRenderLayer, VertexBuffer>(BlockRenderLayer.class);
    private boolean available = true;

    VboSpacecraftModel(SpacecraftBlockAccess blockAccess) {
        this.renderWorld = blockAccess;
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            VertexBuffer buffer = new VertexBuffer(DefaultVertexFormats.field_176600_a);
            buffer.func_177359_a();
            this.bindAttributes();
            BufferBuilder builder = BUILDER;
            builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)blockAccess.getMinPos(), (BlockPos)blockAccess.getMaxPos())) {
                IBlockState state = blockAccess.func_180495_p(pos);
                if (state.func_177230_c() == Blocks.field_150350_a || !state.func_177230_c().canRenderInLayer(state, layer)) continue;
                BLOCK_RENDERER.func_175018_a(state, pos, (IBlockAccess)blockAccess, builder);
            }
            builder.func_178977_d();
            buffer.func_181722_a(builder.func_178966_f());
            buffer.func_177361_b();
            this.buffers.put(layer, buffer);
        }
    }

    @Override
    public void render(BlockRenderLayer layer) {
        if (!this.available) {
            throw new IllegalStateException("Cannot render spacecraft after VBO has been deleted");
        }
        VertexBuffer buffer = this.buffers.get(layer);
        this.enableRenderState();
        buffer.func_177359_a();
        this.bindAttributes();
        buffer.func_177358_a(7);
        buffer.func_177361_b();
        this.disableRenderState();
    }

    @Override
    public void delete() {
        this.available = false;
        this.buffers.values().forEach(VertexBuffer::func_177362_c);
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    private void bindAttributes() {
        GlStateManager.func_187420_d((int)3, (int)5126, (int)28, (int)0);
        GlStateManager.func_187406_e((int)4, (int)5121, (int)28, (int)12);
        GlStateManager.func_187405_c((int)2, (int)5126, (int)28, (int)16);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187405_c((int)2, (int)5122, (int)28, (int)24);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
    }

    private void enableRenderState() {
        GlStateManager.func_187410_q((int)32884);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187410_q((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187410_q((int)32886);
    }

    private void disableRenderState() {
        GlStateManager.func_187429_p((int)32884);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187429_p((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187429_p((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187429_p((int)32886);
    }

    protected void finalize() {
        if (this.available) {
            this.delete();
        }
    }

    @Override
    public SpacecraftBlockAccess getRenderWorld() {
        return this.renderWorld;
    }
}

