/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.client.render.laser;

import it.unimi.dsi.fastutil.longs.Long2IntArrayMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.gegy1000.psf.server.sound.PSFSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

@Mod.EventBusSubscriber(modid="psf")
public class LaserRenderer {
    private static final Random rand = new Random();
    private static Map<BlockPos, LaserState> lasers = new HashMap<BlockPos, LaserState>();
    private static Long2IntMap focus = new Long2IntArrayMap();

    @SubscribeEvent
    public static void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        lasers.clear();
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (world == null || player == null) {
            return;
        }
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179137_b((double)(-TileEntityRendererDispatcher.field_147554_b), (double)(-TileEntityRendererDispatcher.field_147555_c), (double)(-TileEntityRendererDispatcher.field_147552_d));
        for (Map.Entry<BlockPos, LaserState> e : lasers.entrySet()) {
            BlockPos p = e.getKey();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)p.func_177958_n() + 0.5), (double)((double)p.func_177956_o() + 0.5), (double)((double)p.func_177952_p() + 0.5));
            float f = ((float)focus.get(p.func_177986_g()) + event.getPartialTicks()) / 80.0f;
            float radiusMod = e.getValue() == LaserState.FIRING ? (1.0f - f + 0.5f) * 2.0f : 1.0f;
            float alphaMod = e.getValue() == LaserState.FIRING ? MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f) : 1.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)(((float)world.func_82737_E() + event.getPartialTicks()) * 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
            LaserRenderer.drawBox(buf, 512.0f, 0.25f * radiusMod, e.getValue() == LaserState.CHARGING ? 0.2f : 0.5f * alphaMod);
            GlStateManager.func_179121_F();
            if (e.getValue() == LaserState.FIRING) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)(-((float)world.func_82737_E() + event.getPartialTicks()) * 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
                LaserRenderer.drawBox(buf, 512.0f, 0.5f * radiusMod, 0.75f * alphaMod);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
        buf.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179098_w();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (Map.Entry<BlockPos, LaserState> e : lasers.entrySet()) {
                if (e.getValue() != LaserState.FIRING) continue;
                BlockPos p = e.getKey();
                int max = rand.nextInt(5);
                for (int i = 0; i < max; ++i) {
                    double px = (double)p.func_177958_n() + 0.5 + rand.nextGaussian() * 2.0;
                    double py = p.func_177956_o() + 1;
                    double pz = (double)p.func_177952_p() + 0.5 + rand.nextGaussian() * 2.0;
                    Minecraft.func_71410_x().field_71441_e.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, px, py, pz, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            for (Object l : (Object)focus.keySet().toLongArray()) {
                focus.put((long)l, focus.get((long)l) + 1);
            }
        }
    }

    private static void drawBox(BufferBuilder buf, float height, float width, float a) {
        buf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        float w = width / 2.0f;
        float c = 0.5f;
        float min = c - w;
        float max = c + w;
        buf.func_181662_b((double)min, 0.0, (double)min).func_181666_a(0.0f, 1.0f, 1.0f, a).func_181675_d();
        buf.func_181662_b((double)min, 0.0, (double)max).func_181666_a(0.0f, 1.0f, 1.0f, a).func_181675_d();
        buf.func_181662_b((double)min, (double)height, (double)max).func_181666_a(0.0f, 1.0f, 1.0f, a).func_181675_d();
        buf.func_181662_b((double)min, (double)height, (double)min).func_181666_a(0.0f, 1.0f, 1.0f, a).func_181675_d();
        buf.func_181662_b((double)max, 0.0, (double)min).func_181666_a(0.0f, 1.0f, 1.0f, a).func_181675_d();
        buf.func_181662_b((double)max, (double)height, (double)min).func_181666_a(0.0f, 1.0f, 1.0f, a).func_181675_d();
        buf.func_181662_b((double)max, (double)height, (double)max).func_181666_a(0.0f, 1.0f, 1.0f, a).func_181675_d();
        buf.func_181662_b((double)max, 0.0, (double)max).func_181666_a(0.0f, 1.0f, 1.0f, a).func_181675_d();
        buf.func_181662_b((double)min, 0.0, (double)min).func_181666_a(0.0f, 1.0f, 1.0f, a).func_181675_d();
        buf.func_181662_b((double)min, (double)height, (double)min).func_181666_a(0.0f, 1.0f, 1.0f, a).func_181675_d();
        buf.func_181662_b((double)max, (double)height, (double)min).func_181666_a(0.0f, 1.0f, 1.0f, a).func_181675_d();
        buf.func_181662_b((double)max, 0.0, (double)min).func_181666_a(0.0f, 1.0f, 1.0f, a).func_181675_d();
        buf.func_181662_b((double)min, 0.0, (double)max).func_181666_a(0.0f, 1.0f, 1.0f, a).func_181675_d();
        buf.func_181662_b((double)max, 0.0, (double)max).func_181666_a(0.0f, 1.0f, 1.0f, a).func_181675_d();
        buf.func_181662_b((double)max, (double)height, (double)max).func_181666_a(0.0f, 1.0f, 1.0f, a).func_181675_d();
        buf.func_181662_b((double)min, (double)height, (double)max).func_181666_a(0.0f, 1.0f, 1.0f, a).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    private static double lerp(double x1, double x2, float t) {
        return x1 + (double)t * MathHelper.func_76138_g((double)(x2 - x1));
    }

    public static void updateLaser(BlockPos pos, LaserState state) {
        if (state != LaserState.COMPLETE) {
            lasers.put(pos, state);
            if (state == LaserState.FIRING) {
                focus.put(pos.func_177986_g(), 0);
                Minecraft.func_71410_x().field_71441_e.func_184133_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, pos, PSFSounds.LASER_FIRE, SoundCategory.BLOCKS, 4.0f, 1.0f);
            }
        } else {
            lasers.remove(pos);
            focus.remove(pos.func_177986_g());
        }
    }

    public static enum LaserState {
        CHARGING,
        FIRING,
        COMPLETE;

    }
}

