/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.client;

import java.util.List;
import java.util.Random;
import net.gegy1000.psf.server.entity.spacecraft.EntitySpacecraft;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="psf", value={Side.CLIENT})
@SideOnly(value=Side.CLIENT)
public class ClientEventHandler {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static double shakeX;
    private static double shakeY;
    private static double shakeZ;
    private static double lastShakeX;
    private static double lastShakeY;
    private static double lastShakeZ;

    @SubscribeEvent
    public static void onStopTracking(PlayerEvent.StopTracking event) {
        if (event.getTarget() instanceof EntitySpacecraft) {
            EntitySpacecraft spacecraft = (EntitySpacecraft)event.getTarget();
            if (spacecraft.model != null) {
                spacecraft.model.delete();
                spacecraft.model = null;
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ClientEventHandler.MC.field_71439_g != null) {
            lastShakeX = shakeX;
            lastShakeY = shakeY;
            lastShakeZ = shakeZ;
            double totalShake = 0.0;
            List entities = ClientEventHandler.MC.field_71441_e.func_175644_a(EntitySpacecraft.class, s -> true);
            for (EntitySpacecraft spacecraft : entities) {
                double shake = spacecraft.getState().getCameraShake();
                double distance = MathHelper.func_151237_a((double)spacecraft.func_70032_d((Entity)ClientEventHandler.MC.field_71439_g), (double)10.0, (double)400.0);
                totalShake += shake * (1.0 - distance / 350.0);
            }
            if (!(ClientEventHandler.MC.field_71439_g.field_70122_E || ClientEventHandler.MC.field_71439_g.field_70124_G || ClientEventHandler.MC.field_71439_g.field_70123_F)) {
                totalShake *= 0.1;
            }
            if (totalShake > 0.001) {
                totalShake = Math.min(totalShake, 0.25);
                Random rand = ClientEventHandler.MC.field_71441_e.field_73012_v;
                shakeX = (rand.nextDouble() * 2.0 - 1.0) * totalShake;
                shakeY = (rand.nextDouble() * 2.0 - 1.0) * totalShake;
                shakeZ = (rand.nextDouble() * 2.0 - 1.0) * totalShake;
            }
        }
    }

    @SubscribeEvent
    public static void onSetupCamera(EntityViewRenderEvent.CameraSetup setup) {
        double lerpShakeX = lastShakeX + (shakeX - lastShakeX) * (double)MC.func_184121_ak();
        double lerpShakeY = lastShakeY + (shakeY - lastShakeY) * (double)MC.func_184121_ak();
        double lerpShakeZ = lastShakeZ + (shakeZ - lastShakeZ) * (double)MC.func_184121_ak();
        GlStateManager.func_179137_b((double)lerpShakeX, (double)lerpShakeY, (double)lerpShakeZ);
    }
}

