/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.api;

import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.gegy1000.psf.api.IController;
import net.gegy1000.psf.api.IModule;
import net.gegy1000.psf.api.IUnique;
import net.gegy1000.psf.server.block.remote.IListedSpacecraft;
import net.gegy1000.psf.server.entity.spacecraft.SpacecraftBlockAccess;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

@ParametersAreNonnullByDefault
public interface ISatellite
extends IUnique,
IListedSpacecraft,
INBTSerializable<NBTTagCompound> {
    @Override
    default public String getName() {
        return "Unnamed Craft #" + this.hashCode() % 1000;
    }

    @Override
    default public void requestVisualData() {
    }

    public IController getController();

    public Collection<IModule> getModules();

    default public Map<UUID, IModule> getIndexedModules() {
        return this.getModules().stream().collect(Collectors.toMap(IUnique::getId, Functions.identity()));
    }

    default public boolean tryExtractEnergy(int amount) {
        int extractedAmount = 0;
        for (IEnergyStorage storage : this.getModuleCaps(CapabilityEnergy.ENERGY)) {
            int extracted;
            if (!storage.canExtract() || (extractedAmount += (extracted = storage.extractEnergy(amount - extractedAmount, false))) != amount) continue;
            return true;
        }
        return false;
    }

    default public <T> Collection<T> getModuleCaps(Capability<T> capability) {
        ArrayList<T> caps = new ArrayList<T>();
        for (IModule module : this.getModules()) {
            if (!module.hasCapability(capability, null)) continue;
            caps.add(module.getCapability(capability, null));
        }
        return caps;
    }

    public SpacecraftBlockAccess buildBlockAccess(World var1);

    public IListedSpacecraft toListedCraft();

    public World getWorld();

    default public NBTTagCompound serializeNBT() {
        return new NBTTagCompound();
    }

    default public void deserializeNBT(@Nullable NBTTagCompound tag) {
    }

    default public void tickSatellite(long ticksExisted) {
        for (IModule module : this.getModules()) {
            if (this.isOrbiting() && ticksExisted % (long)module.getTickInterval() == 0L) {
                module.onSatelliteTick(this);
            }
            if (!module.isDirty()) continue;
            this.sendModulePacket(module, module.getUpdateTag());
            module.dirty(false);
        }
    }

    default public void updateModuleClient(UUID id, NBTTagCompound data) {
        IModule module = this.getIndexedModules().get(id);
        if (module != null) {
            module.readUpdateTag(data);
        }
    }

    public void sendModulePacket(IModule var1, NBTTagCompound var2);

    default public Collection<EntityPlayerMP> getTrackingPlayers() {
        return Collections.emptyList();
    }

    default public void track(EntityPlayerMP player) {
    }

    default public void untrack(EntityPlayerMP player) {
    }
}

