/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.psf.api;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.gegy1000.psf.api.IModuleConfig;
import net.gegy1000.psf.api.ISatellite;
import net.gegy1000.psf.api.IUnique;
import net.gegy1000.psf.api.data.IModuleData;
import net.gegy1000.psf.server.capability.CapabilityModule;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public interface IModule
extends IUnique,
INBTSerializable<NBTTagCompound>,
ICapabilityProvider {
    default public void onSatelliteTick(ISatellite satellite) {
    }

    default public int getTickInterval() {
        return 20;
    }

    public String getName();

    @SideOnly(value=Side.CLIENT)
    default public String getLocalizedName() {
        return I18n.func_135052_a((String)String.format("tile.%s.module.%s.name", "psf", this.getName()), (Object[])new Object[0]);
    }

    @Nullable
    public ResourceLocation getRegistryName();

    public IModule setRegistryName(@Nullable ResourceLocation var1);

    default public <T extends IModuleData> Collection<T> getConnectedCaps(ISatellite satellite, Capability<T> capability) {
        return satellite.getModuleCaps(capability);
    }

    default public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityModule.INSTANCE;
    }

    @Nullable
    default public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.hasCapability(capability, facing) && capability == CapabilityModule.INSTANCE) {
            return (T)CapabilityModule.INSTANCE.cast((Object)this);
        }
        return null;
    }

    default public boolean groupWith(IModule other) {
        return other.getClass() == this.getClass();
    }

    default public Collection<IModuleConfig> getConfigs() {
        return Collections.emptyList();
    }

    @Nullable
    default public IModuleConfig getConfig(String key) {
        return null;
    }

    default public List<String> getSummary() {
        return Collections.emptyList();
    }

    default public boolean isDirty() {
        return false;
    }

    default public void dirty(boolean dirty) {
    }

    default public NBTTagCompound getUpdateTag() {
        return (NBTTagCompound)this.serializeNBT();
    }

    default public void readUpdateTag(NBTTagCompound tag) {
        this.deserializeNBT((NBTBase)tag);
    }
}

