/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.util;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class UniqueQueue<E>
implements Queue<E> {
    private final Queue<E> queue;
    private final Set<E> set;

    public static <E> UniqueQueue<E> create() {
        return new UniqueQueue(new ArrayDeque(), new HashSet());
    }

    public static <E> UniqueQueue<E> concurrent() {
        return new UniqueQueue(new ArrayDeque(), Collections.newSetFromMap(new ConcurrentHashMap()));
    }

    public UniqueQueue(Queue<E> queue, Set<E> set) {
        this.queue = queue;
        this.set = set;
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.queue.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.queue.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.set.add(e) && this.queue.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o) && this.queue.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.contains(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean altered = false;
        for (E e : c) {
            altered |= this.add(e);
        }
        return altered;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.set.removeAll(c) && this.queue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.set.retainAll(c) && this.queue.retainAll(c);
    }

    @Override
    public void clear() {
        this.set.clear();
        this.queue.clear();
    }

    @Override
    public boolean offer(E e) {
        return !this.set.contains(e) && this.queue.offer(e) && this.set.add(e);
    }

    @Override
    public E remove() {
        E e = this.queue.remove();
        this.set.remove(e);
        return e;
    }

    @Override
    public E poll() {
        E e = this.queue.poll();
        if (e != null) {
            this.set.remove(e);
        }
        return e;
    }

    @Override
    public E element() {
        return this.queue.element();
    }

    @Override
    public E peek() {
        return this.queue.peek();
    }
}

