/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.util;

import java.lang.ref.WeakReference;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SimpleManager {
    private final WeakReference<World> world;

    public SimpleManager(World world) {
        this.world = new WeakReference<World>(world);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected World getWorld() {
        return (World)this.world.get();
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (this.world.get() == null) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            return;
        }
        if (event.phase == TickEvent.Phase.START || event.world != this.world.get()) {
            return;
        }
        this.update((World)this.world.get());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.world.get() == null) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        this.update((World)this.world.get());
    }

    @SubscribeEvent
    public void onUnload(WorldEvent.Unload event) {
        if (event.getWorld() == this.world.get()) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    protected abstract void update(World var1);
}

