/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.util;

import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.HashSet;
import java.util.Set;
import mod.crystals.api.IResonant;
import mod.crystals.api.NatureType;
import mod.crystals.capability.CapabilityCrystalCache;
import mod.crystals.capability.CapabilityLoadedCache;
import mod.crystals.crystal.ChunkCrystalCache;
import mod.crystals.init.CrystalsRegistries;
import mod.crystals.tile.TileCrystalBase;
import mod.crystals.tile.TileCrystalCreative;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ResonantUtils {
    public static IResonant getCrystal(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileCrystalBase) {
            return (IResonant)te.getCapability(IResonant.CAPABILITY, null);
        }
        return null;
    }

    public static Set<TileCrystalBase> getCrystalsAround(World world, BlockPos pos, float radius, TileCrystalBase ignored) {
        HashSet<TileCrystalBase> crystals = new HashSet<TileCrystalBase>();
        ChunkPos min = new ChunkPos(pos.func_177963_a((double)(-radius), 0.0, (double)(-radius)));
        ChunkPos max = new ChunkPos(pos.func_177963_a((double)radius, 0.0, (double)radius));
        CapabilityLoadedCache.LoadedChunks loaded = (CapabilityLoadedCache.LoadedChunks)world.getCapability(CapabilityLoadedCache.CAPABILITY, null);
        for (int x = min.field_77276_a; x <= max.field_77276_a; ++x) {
            for (int z = min.field_77275_b; z <= max.field_77275_b; ++z) {
                if (!loaded.isLoaded(x, z)) continue;
                Chunk c = world.func_72964_e(x, z);
                for (TileCrystalBase crystal : ((ChunkCrystalCache)c.getCapability(CapabilityCrystalCache.CAPABILITY, null)).getCrystals()) {
                    if (crystal == ignored || !(crystal.func_174877_v().func_177951_i((Vec3i)pos) < (double)(radius * radius))) continue;
                    crystals.add(crystal);
                }
            }
        }
        return crystals;
    }

    public static TObjectFloatMap<NatureType> getNatureTypes(IResonant resonant, boolean copy) {
        if (resonant instanceof IResonant.Default) {
            TObjectFloatHashMap map = ((IResonant.Default)resonant).getNatureAmounts();
            return !copy ? map : new TObjectFloatHashMap((TObjectFloatMap)map);
        }
        TObjectFloatHashMap map = new TObjectFloatHashMap();
        for (NatureType type : CrystalsRegistries.natureRegistry.getValuesCollection()) {
            float amt = resonant.getNatureAmount(type);
            if ((double)amt < 1.0E-4) continue;
            map.put((Object)type, amt);
        }
        return map;
    }

    public static void balance(TObjectFloatMap<NatureType> map1, TObjectFloatMap<NatureType> map2, float res1, float res2, float amt) {
        HashSet<NatureType> visited = new HashSet<NatureType>();
        float totalDif = 0.0f;
        for (NatureType type : map1.keySet()) {
            visited.add(type);
            totalDif += Math.abs(map1.get((Object)type) * res1 - map2.get((Object)type) * res2);
        }
        for (NatureType type : map2.keySet()) {
            if (!visited.add(type)) continue;
            totalDif += map2.get((Object)type) * res2;
        }
        if ((double)totalDif < 1.0E-4) {
            return;
        }
        float dif = Math.min(totalDif, amt);
        for (NatureType type : visited) {
            visited.add(type);
            float amt1 = map1.containsKey((Object)type) ? map1.get((Object)type) * res1 : 0.0f;
            float amt2 = map2.containsKey((Object)type) ? map2.get((Object)type) * res2 : 0.0f;
            float transfered = dif * (Math.abs(amt1 - amt2) / totalDif) / 2.0f;
            if (amt1 < amt2) {
                map1.adjustOrPutValue((Object)type, transfered, transfered);
                map2.adjustValue((Object)type, -transfered);
                continue;
            }
            map1.adjustValue((Object)type, -transfered);
            map2.adjustOrPutValue((Object)type, transfered, transfered);
        }
    }

    public static float getMatch(IResonant res1, IResonant res2) {
        if (res1 == TileCrystalCreative.CreativeResonant.instance || res2 == TileCrystalCreative.CreativeResonant.instance) {
            return 1.0f;
        }
        TObjectFloatMap<NatureType> map1 = ResonantUtils.getNatureTypes(res1, false);
        TObjectFloatMap<NatureType> map2 = ResonantUtils.getNatureTypes(res2, false);
        HashSet<NatureType> visited = new HashSet<NatureType>();
        float dif = 0.0f;
        for (NatureType type : map1.keySet()) {
            visited.add(type);
            dif += Math.abs(map1.get((Object)type) - map2.get((Object)type));
        }
        for (NatureType type : map2.keySet()) {
            if (!visited.add(type)) continue;
            dif += map2.get((Object)type);
        }
        return 1.0f - dif / 2.0f;
    }
}

