/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.util;

import mod.crystals.api.ILaserRayTrace;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RayTracer {
    public static RayTraceResult rayTraceLaser(World world, Vec3d start, Vec3d end) {
        int sZ;
        int sY;
        if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
            return null;
        }
        if (Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c)) {
            return null;
        }
        int eX = MathHelper.func_76128_c((double)end.field_72450_a);
        int eY = MathHelper.func_76128_c((double)end.field_72448_b);
        int eZ = MathHelper.func_76128_c((double)end.field_72449_c);
        int sX = MathHelper.func_76128_c((double)start.field_72450_a);
        BlockPos pos = new BlockPos(sX, sY = MathHelper.func_76128_c((double)start.field_72448_b), sZ = MathHelper.func_76128_c((double)start.field_72449_c));
        RayTraceResult hit1 = RayTracer.rayTest(world, pos, start, end);
        if (hit1 != null) {
            return hit1;
        }
        for (int i = 200; i >= 0; --i) {
            EnumFacing side;
            if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
                return null;
            }
            if (sX == eX && sY == eY && sZ == eZ) {
                return null;
            }
            boolean flagX = true;
            boolean flagY = true;
            boolean flagZ = true;
            double d0 = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (eX > sX) {
                d0 = (double)sX + 1.0;
            } else if (eX < sX) {
                d0 = (double)sX + 0.0;
            } else {
                flagX = false;
            }
            if (eY > sY) {
                d1 = (double)sY + 1.0;
            } else if (eY < sY) {
                d1 = (double)sY + 0.0;
            } else {
                flagY = false;
            }
            if (eZ > sZ) {
                d2 = (double)sZ + 1.0;
            } else if (eZ < sZ) {
                d2 = (double)sZ + 0.0;
            } else {
                flagZ = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = end.field_72450_a - start.field_72450_a;
            double d7 = end.field_72448_b - start.field_72448_b;
            double d8 = end.field_72449_c - start.field_72449_c;
            if (flagX) {
                d3 = (d0 - start.field_72450_a) / d6;
            }
            if (flagY) {
                d4 = (d1 - start.field_72448_b) / d7;
            }
            if (flagZ) {
                d5 = (d2 - start.field_72449_c) / d8;
            }
            if (d3 == -0.0) {
                d3 = -1.0E-4;
            }
            if (d4 == -0.0) {
                d4 = -1.0E-4;
            }
            if (d5 == -0.0) {
                d5 = -1.0E-4;
            }
            if (d3 < d4 && d3 < d5) {
                side = eX > sX ? EnumFacing.WEST : EnumFacing.EAST;
                start = new Vec3d(d0, start.field_72448_b + d7 * d3, start.field_72449_c + d8 * d3);
            } else if (d4 < d5) {
                side = eY > sY ? EnumFacing.DOWN : EnumFacing.UP;
                start = new Vec3d(start.field_72450_a + d6 * d4, d1, start.field_72449_c + d8 * d4);
            } else {
                side = eZ > sZ ? EnumFacing.NORTH : EnumFacing.SOUTH;
                start = new Vec3d(start.field_72450_a + d6 * d5, start.field_72448_b + d7 * d5, d2);
            }
            sX = MathHelper.func_76128_c((double)start.field_72450_a) - (side == EnumFacing.EAST ? 1 : 0);
            sY = MathHelper.func_76128_c((double)start.field_72448_b) - (side == EnumFacing.UP ? 1 : 0);
            sZ = MathHelper.func_76128_c((double)start.field_72449_c) - (side == EnumFacing.SOUTH ? 1 : 0);
            pos = new BlockPos(sX, sY, sZ);
            RayTraceResult hit = RayTracer.rayTest(world, pos, start, end);
            if (hit == null) continue;
            return hit;
        }
        return null;
    }

    private static RayTraceResult rayTest(World world, BlockPos pos, Vec3d start, Vec3d end) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof ILaserRayTrace) {
            return ((ILaserRayTrace)block).laserRayTrace(world, pos, start, end);
        }
        if (block.func_176209_a(state, false)) {
            return state.func_185910_a(world, pos, start, end);
        }
        return null;
    }
}

