/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.tile;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.crystals.api.NatureType;
import mod.crystals.api.seal.SealType;
import mod.crystals.block.BlockSeal;
import mod.crystals.init.CrystalsRegistries;
import mod.crystals.util.SealUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileSlate
extends TileEntity {
    private final Set<NatureType> natures = new HashSet<NatureType>();

    public boolean putDust(@Nullable NatureType type) {
        if (type == null) {
            return false;
        }
        if (this.natures.size() == 4) {
            return false;
        }
        if (this.func_145831_w().field_72995_K) {
            return !this.natures.contains((Object)type);
        }
        if (this.natures.add(type)) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
        return false;
    }

    public int getDustCount() {
        return this.natures.size();
    }

    public Set<NatureType> getNatures() {
        return this.natures;
    }

    public boolean tryForm() {
        TileSlate[][] slates = new TileSlate[3][3];
        if (!this.findSlates(slates)) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            SealType type = this.identifySeal(slates);
            if (type != null) {
                World world = this.func_145831_w();
                BlockPos pos = this.func_174877_v();
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        this.func_145831_w().func_175698_g(pos.func_177982_a(x, 0, z));
                    }
                }
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)BlockSeal.createStack(type));
                return true;
            }
            if (i == 3) continue;
            slates = this.rotate(slates);
        }
        return false;
    }

    private boolean findSlates(TileSlate[][] slates) {
        slates[1][1] = this;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177982_a(x, 0, z));
                if (te instanceof TileSlate) {
                    slates[x + 1][z + 1] = (TileSlate)te;
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    private TileSlate[][] rotate(TileSlate[][] tiles) {
        TileSlate[][] slates = new TileSlate[3][3];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                slates[y][2 - x] = tiles[x][y];
            }
        }
        return slates;
    }

    private SealType identifySeal(TileSlate[][] slates) {
        for (SealType sealType : CrystalsRegistries.sealTypeRegistry) {
            SealType.Ingredient[][] ingredients = SealUtils.getIngredients(sealType);
            boolean failed = false;
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    if (ingredients[x][y] == null) {
                        if (slates[x][y].natures.isEmpty()) continue;
                        failed = true;
                        break;
                    }
                    if (ingredients[x][y].matches(slates[x][y].natures)) continue;
                    failed = true;
                    break;
                }
                if (failed) break;
            }
            if (failed) continue;
            return sealType;
        }
        return null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList list = new NBTTagList();
        for (NatureType type : this.natures) {
            list.func_74742_a((NBTBase)new NBTTagString(type.getRegistryName().toString()));
        }
        compound.func_74782_a("natures", (NBTBase)list);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList list = compound.func_150295_c("natures", 8);
        this.natures.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.natures.add((NatureType)CrystalsRegistries.natureRegistry.getValue(new ResourceLocation(list.func_150307_f(i))));
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        this.func_145839_a(tag);
        this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }
}

