/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.tile;

import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.crystals.CrystalsMod;
import mod.crystals.api.seal.ISeal;
import mod.crystals.api.seal.ISealInstance;
import mod.crystals.api.seal.SealType;
import mod.crystals.block.BlockSealExt;
import mod.crystals.capability.CapabilitySealManager;
import mod.crystals.init.CrystalsBlocks;
import mod.crystals.init.CrystalsRegistries;
import mod.crystals.network.PacketSealData;
import mod.crystals.seal.SealManager;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileSeal
extends TileEntity
implements ITickable {
    private final Host host = new Host();
    private SealType type;
    private ISealInstance seal;
    private boolean needsSync = false;

    public void func_73660_a() {
        if (this.seal == null) {
            return;
        }
        this.seal.update();
        if (this.needsSync && !this.field_145850_b.field_72995_K) {
            PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
            this.seal.writeClientData(buf);
            PacketSealData packet = PacketSealData.create(this.func_174877_v(), buf);
            CrystalsMod.net.sendToDimension((IMessage)packet, this.field_145850_b.field_73011_w.getDimension());
        }
        this.needsSync = false;
        this.func_70296_d();
    }

    public void setSeal(SealType type) {
        if (type != this.type || this.seal == null) {
            this.type = type;
            this.seal = type.instantiate(this.host);
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        ((SealManager)this.func_145831_w().getCapability(CapabilitySealManager.CAPABILITY, null)).add(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        ((SealManager)this.func_145831_w().getCapability(CapabilitySealManager.CAPABILITY, null)).remove(this);
    }

    public void onLoad() {
        super.onLoad();
        ((SealManager)this.func_145831_w().getCapability(CapabilitySealManager.CAPABILITY, null)).add(this);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        ((SealManager)this.func_145831_w().getCapability(CapabilitySealManager.CAPABILITY, null)).remove(this);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.type != null) {
            tag.func_74778_a("type", this.type.getRegistryName().toString());
            tag.func_74782_a("data", (NBTBase)this.seal.writeToNBT(new NBTTagCompound()));
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("type")) {
            SealType type = (SealType)CrystalsRegistries.sealTypeRegistry.getValue(new ResourceLocation(tag.func_74779_i("type")));
            this.setSeal(type);
            this.seal.readFromNBT(tag.func_74775_l("data"));
        }
    }

    public Iterable<BlockPos> getSealBox() {
        return BlockSealExt.getSealBounds(this.getSealType().getSize(), this.getFace(), this.func_174877_v());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        if (this.type != null) {
            tag.func_74778_a("type", this.type.getRegistryName().toString());
            PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
            this.seal.writeClientData(buf);
            tag.func_74773_a("data", PacketSealData.create((BlockPos)this.func_174877_v(), (PacketBuffer)buf).data);
        }
        return tag;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        if (tag.func_74764_b("type")) {
            SealType type = (SealType)CrystalsRegistries.sealTypeRegistry.getValue(new ResourceLocation(tag.func_74779_i("type")));
            this.setSeal(type);
            if (tag.func_74764_b("data")) {
                this.getSeal().readClientData(new PacketBuffer(Unpooled.wrappedBuffer((byte[])tag.func_74770_j("data"))));
            }
        }
    }

    @Nullable
    public SealType getSealType() {
        return this.type;
    }

    public ISealInstance getSeal() {
        return this.seal;
    }

    public EnumFacing getFace() {
        IBlockState blockState = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (blockState.func_177230_c() != CrystalsBlocks.seal) {
            return EnumFacing.DOWN;
        }
        return (EnumFacing)blockState.func_177229_b((IProperty)BlockDirectional.field_176387_N);
    }

    private class Host
    implements ISeal {
        private Host() {
        }

        @Override
        public World getWorld() {
            return TileSeal.this.func_145831_w();
        }

        @Override
        public BlockPos getPos() {
            return TileSeal.this.func_174877_v();
        }

        @Override
        public EnumFacing getFace() {
            return TileSeal.this.getFace();
        }

        @Override
        public void sync() {
            TileSeal.this.needsSync = true;
        }
    }
}

