/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.tile;

import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.crystals.CrystalsMod;
import mod.crystals.api.IResonant;
import mod.crystals.api.NatureType;
import mod.crystals.capability.CapabilityCrystalCache;
import mod.crystals.capability.CapabilityLoadedCache;
import mod.crystals.capability.CapabilityRayManager;
import mod.crystals.client.particle.ParticleType;
import mod.crystals.crystal.ChunkCrystalCache;
import mod.crystals.crystal.ILaserSource;
import mod.crystals.crystal.Ray;
import mod.crystals.crystal.RayManager;
import mod.crystals.environment.EnvironmentHandler;
import mod.crystals.util.ResonantUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import org.apache.commons.lang3.tuple.Pair;

public abstract class TileCrystalBase
extends TileEntity
implements ILaserSource,
ITickable {
    public static final float MAX_DISTANCE = 8.0f;
    public static final Vec3d OFFSET = new Vec3d(0.5, 0.5, 0.5);
    protected IResonant.Default resonant;
    protected Set<Ray> rays = new HashSet<Ray>();
    protected boolean needsJoin = false;

    public TileCrystalBase(IResonant.Default resonant) {
        resonant.addChangeListener(this::onChanged);
        this.resonant = resonant;
    }

    public void doJoin() {
        if (!CapabilityLoadedCache.isLoaded(this.func_145831_w(), this.func_174877_v())) {
            return;
        }
        Chunk chunk = this.func_145831_w().func_175726_f(this.func_174877_v());
        ((ChunkCrystalCache)chunk.getCapability(CapabilityCrystalCache.CAPABILITY, null)).join(this);
        ResonantUtils.getCrystalsAround(this.func_145831_w(), this.func_174877_v(), 8.0f, this).forEach(this::connect);
        this.needsJoin = false;
    }

    protected void onChanged() {
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
        this.func_70296_d();
    }

    protected void join() {
        this.needsJoin = true;
    }

    protected void leave() {
        Chunk chunk = this.func_145831_w().func_175726_f(this.func_174877_v());
        ((ChunkCrystalCache)chunk.getCapability(CapabilityCrystalCache.CAPABILITY, null)).leave(this);
        this.disconnect();
    }

    protected void connect(TileCrystalBase crystal) {
        float match = ResonantUtils.getMatch(this.resonant, crystal.resonant);
        if ((double)match < 0.8) {
            return;
        }
        RayManager manager = (RayManager)this.func_145831_w().getCapability(CapabilityRayManager.CAPABILITY, null);
        manager.addRay(this, crystal);
    }

    protected void disconnect() {
        RayManager manager = (RayManager)this.func_145831_w().getCapability(CapabilityRayManager.CAPABILITY, null);
        manager.removeAll(this);
    }

    @Override
    public void onConnect(ILaserSource other, Ray ray) {
        this.rays.add(ray);
    }

    @Override
    public void onDisconnect(ILaserSource other, Ray ray) {
        this.rays.remove(ray);
    }

    @Override
    public boolean shouldIgnore(BlockPos pos) {
        return pos.equals((Object)this.func_174877_v());
    }

    public void func_73660_a() {
        if (this.needsJoin) {
            this.doJoin();
        }
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.rays.isEmpty()) {
            return;
        }
        if (this.rays.stream().noneMatch(Ray::hasLineOfSight)) {
            return;
        }
        Vec3d pos = this.getPosition(0.0f, true);
        Color color = new Color(this.resonant.getColor());
        CrystalsMod.proxy.spawnParticle(this.field_145850_b, ParticleType.CIRCLE, ParticleType.posVelocityColor(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f));
    }

    public TObjectFloatMap<NatureType> visit() {
        TObjectFloatHashMap total = new TObjectFloatHashMap();
        ArrayDeque<Pair<TileCrystalBase, TObjectFloatMap<NatureType>>> queue = new ArrayDeque<Pair<TileCrystalBase, TObjectFloatMap<NatureType>>>();
        HashSet<TileCrystalBase> visited = new HashSet<TileCrystalBase>();
        queue.add(Pair.of((Object)this, this.resonant.getNatureAmounts()));
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.poll();
            ((TileCrystalBase)pair.getKey()).visit(queue, visited, (TObjectFloatMap<NatureType>)((TObjectFloatMap)pair.getValue()), (TObjectFloatMap<NatureType>)total);
        }
        return total;
    }

    protected void visit(Queue<Pair<TileCrystalBase, TObjectFloatMap<NatureType>>> queue, Set<TileCrystalBase> visited, TObjectFloatMap<NatureType> cap, TObjectFloatMap<NatureType> total) {
        this.addAvailableNatures(cap, total);
        for (Ray ray : this.rays) {
            ILaserSource other;
            if (!ray.hasLineOfSight() || !((other = ray.getEnd()) instanceof TileCrystalBase) || !visited.add((TileCrystalBase)other)) continue;
            TileCrystalBase crystal = (TileCrystalBase)other;
            TObjectFloatHashMap newCap = new TObjectFloatHashMap();
            cap.forEachEntry((arg_0, arg_1) -> TileCrystalBase.lambda$visit$0(crystal, (TObjectFloatMap)newCap, arg_0, arg_1));
            queue.add((Pair<TileCrystalBase, TObjectFloatMap<NatureType>>)Pair.of((Object)crystal, (Object)newCap));
        }
    }

    protected void addAvailableNatures(TObjectFloatMap<NatureType> cap, TObjectFloatMap<NatureType> total) {
        TObjectFloatMap<NatureType> worldNatures = EnvironmentHandler.INSTANCE.getNature(this.field_145850_b, this.func_174877_v());
        this.resonant.getNatureAmounts().forEachEntry((type, amt) -> {
            float max = Math.min(cap.get((Object)type), worldNatures.get((Object)type));
            float a = Math.min(amt, max);
            total.adjustOrPutValue((Object)type, a, a);
            return true;
        });
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        this.func_145839_a(tag);
        this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        this.leave();
        this.join();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
        this.leave();
        this.join();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == IResonant.CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == IResonant.CAPABILITY) {
            return (T)this.resonant;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.needsJoin = true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.leave();
    }

    public void onLoad() {
        super.onLoad();
        this.needsJoin = true;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.leave();
    }

    private static /* synthetic */ boolean lambda$visit$0(TileCrystalBase crystal, TObjectFloatMap newCap, NatureType type, float max) {
        float amt = crystal.resonant.getNatureAmount(type);
        newCap.put((Object)type, Math.min(amt, max));
        return true;
    }
}

