/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.seal;

import java.util.function.BiConsumer;
import mod.crystals.api.NatureType;
import mod.crystals.api.seal.ISeal;
import mod.crystals.api.seal.ISealInstance;
import mod.crystals.api.seal.SealType;
import mod.crystals.seal.AbstractSeal;
import mod.crystals.seal.SealRain;

public class SealThunder
extends SealType {
    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public int getTint() {
        return NatureType.WATER.getColor();
    }

    @Override
    public SealType.Ingredient[][] createRecipe() {
        SealType.Ingredient cloud = new SealType.Ingredient(NatureType.WATER, NatureType.AIR, NatureType.DISTORTED);
        SealType.Ingredient rain = new SealType.Ingredient(NatureType.WATER, NatureType.AIR);
        SealType.Ingredient thunder = new SealType.Ingredient(NatureType.FIRE, NatureType.AIR, NatureType.DISTORTED);
        return new SealType.Ingredient[][]{{cloud, cloud, cloud}, {rain, thunder, rain}, {rain, thunder, rain}};
    }

    @Override
    public ISealInstance instantiate(ISeal seal) {
        return new Instance(seal);
    }

    private static class Instance
    extends AbstractSeal {
        public Instance(ISeal seal) {
            super(seal);
        }

        @Override
        public void addRequirements(BiConsumer<NatureType, Float> capacity, BiConsumer<NatureType, Float> consumption) {
            capacity.accept(NatureType.WATER, Float.valueOf(5000.0f));
            capacity.accept(NatureType.AIR, Float.valueOf(5000.0f));
            capacity.accept(NatureType.FIRE, Float.valueOf(2500.0f));
            capacity.accept(NatureType.DISTORTED, Float.valueOf(2500.0f));
            consumption.accept(NatureType.WATER, Float.valueOf(5000.0f));
            consumption.accept(NatureType.AIR, Float.valueOf(5000.0f));
            consumption.accept(NatureType.FIRE, Float.valueOf(2500.0f));
            consumption.accept(NatureType.DISTORTED, Float.valueOf(2500.0f));
        }

        @Override
        public void update() {
            SealRain.startRain(this.seal, true, 6000, this::consumeEnergy);
        }
    }
}

