/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.seal;

import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import mod.crystals.api.NatureType;
import mod.crystals.api.seal.ISeal;
import mod.crystals.api.seal.ISealInstance;
import mod.crystals.api.seal.SealType;
import mod.crystals.seal.AbstractSeal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;

public class SealRain
extends SealType {
    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public int getTint() {
        return NatureType.WATER.getColor();
    }

    @Override
    public SealType.Ingredient[][] createRecipe() {
        SealType.Ingredient cloud = new SealType.Ingredient(NatureType.WATER, NatureType.AIR, NatureType.DISTORTED);
        SealType.Ingredient rain = new SealType.Ingredient(NatureType.WATER, NatureType.AIR);
        return new SealType.Ingredient[][]{{cloud, cloud, cloud}, {rain, rain, rain}, {rain, rain, rain}};
    }

    @Override
    public ISealInstance instantiate(ISeal seal) {
        return new Instance(seal);
    }

    public static void startRain(ISeal seal, boolean thunder, int duration, BooleanSupplier consume) {
        World world = seal.getWorld();
        if (world.field_72995_K) {
            return;
        }
        if (world.func_72896_J()) {
            return;
        }
        for (EntityItem item : world.func_72872_a(EntityItem.class, new AxisAlignedBB(seal.getPos()))) {
            ItemStack stack = item.func_92059_d();
            if (stack.func_190926_b() || stack.func_77973_b() != Items.field_151131_as) continue;
            if (!consume.getAsBoolean()) {
                return;
            }
            WorldInfo info = world.func_72912_H();
            info.func_176142_i(0);
            info.func_76080_g(duration);
            info.func_76090_f(duration);
            info.func_76084_b(true);
            info.func_76069_a(thunder);
            item.func_70106_y();
            return;
        }
    }

    private class Instance
    extends AbstractSeal {
        public Instance(ISeal seal) {
            super(seal);
        }

        @Override
        public void addRequirements(BiConsumer<NatureType, Float> capacity, BiConsumer<NatureType, Float> consumption) {
            capacity.accept(NatureType.WATER, Float.valueOf(5000.0f));
            capacity.accept(NatureType.AIR, Float.valueOf(5000.0f));
            capacity.accept(NatureType.DISTORTED, Float.valueOf(2500.0f));
            consumption.accept(NatureType.WATER, Float.valueOf(5000.0f));
            consumption.accept(NatureType.AIR, Float.valueOf(5000.0f));
            consumption.accept(NatureType.DISTORTED, Float.valueOf(2500.0f));
        }

        @Override
        public void update() {
            SealRain.startRain(this.seal, false, 6000, this::consumeEnergy);
        }
    }
}

