/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.seal;

import java.util.function.BiConsumer;
import mod.crystals.api.NatureType;
import mod.crystals.api.seal.ISeal;
import mod.crystals.api.seal.ISealInstance;
import mod.crystals.api.seal.SealType;
import mod.crystals.seal.AbstractSeal;
import mod.crystals.seal.SealPullRadial;

public class SealPushRadial
extends SealType {
    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public int getTint() {
        return NatureType.AIR.getColor();
    }

    @Override
    public SealType.Ingredient[][] createRecipe() {
        SealType.Ingredient wind = new SealType.Ingredient(NatureType.AIR);
        SealType.Ingredient push = new SealType.Ingredient(NatureType.AIR, NatureType.DISTORTED);
        return new SealType.Ingredient[][]{{wind, wind, wind}, {wind, push, wind}, {wind, wind, wind}};
    }

    @Override
    public ISealInstance instantiate(ISeal seal) {
        return new Instance(seal);
    }

    private static class Instance
    extends AbstractSeal {
        public Instance(ISeal seal) {
            super(seal);
        }

        @Override
        public void addRequirements(BiConsumer<NatureType, Float> capacity, BiConsumer<NatureType, Float> consumption) {
            capacity.accept(NatureType.AIR, Float.valueOf(500.0f));
            consumption.accept(NatureType.AIR, Float.valueOf(100.0f));
        }

        @Override
        public void update() {
            SealPullRadial.moveEntities(this.seal, false, this::consumeEnergy);
        }
    }
}

