/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.seal;

import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import mod.crystals.api.NatureType;
import mod.crystals.api.seal.ISeal;
import mod.crystals.api.seal.ISealInstance;
import mod.crystals.api.seal.SealType;
import mod.crystals.seal.AbstractSeal;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class SealPullRadial
extends SealType {
    private static final float RADIUS = 5.0f;
    private static final float MAX_DIST = 75.0f;

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public int getTint() {
        return NatureType.AIR.getColor();
    }

    @Override
    public SealType.Ingredient[][] createRecipe() {
        SealType.Ingredient wind = new SealType.Ingredient(NatureType.AIR);
        SealType.Ingredient pull = new SealType.Ingredient(NatureType.AIR, NatureType.VOID);
        return new SealType.Ingredient[][]{{wind, wind, wind}, {wind, pull, wind}, {wind, wind, wind}};
    }

    @Override
    public ISealInstance instantiate(ISeal seal) {
        return new Instance(seal);
    }

    public static void moveEntities(ISeal seal, boolean pull, BooleanSupplier consume) {
        EnumFacing face = seal.getFace().func_176734_d();
        AxisAlignedBB bounds = AbstractSeal.getAreaInFront(seal, 5.0f, true);
        Vec3d center = new Vec3d((Vec3i)seal.getPos()).func_72441_c(0.5, 0.5, 0.5).func_178787_e(new Vec3d(face.func_176730_m()).func_186678_a(0.5));
        for (Entity entity : seal.getWorld().func_72839_b(null, bounds)) {
            if (!consume.getAsBoolean()) {
                return;
            }
            Vec3d direction = entity.func_174791_d().func_178788_d(center);
            direction = direction.func_72432_b().func_186678_a(0.15 * Math.max(0.0, 75.0 - direction.func_189985_c()) / 75.0).func_186678_a(pull ? -1.0 : 1.0);
            entity.field_70159_w += direction.field_72450_a;
            entity.field_70181_x += direction.field_72448_b;
            entity.field_70179_y += direction.field_72449_c;
            if (!seal.getWorld().field_72995_K || !(direction.func_189985_c() > 0.0)) continue;
            if (pull) {
                seal.getWorld().func_175688_a(EnumParticleTypes.CLOUD, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, direction.field_72450_a * 5.0, direction.field_72448_b * 5.0, direction.field_72449_c * 5.0, new int[0]);
                continue;
            }
            seal.getWorld().func_175688_a(EnumParticleTypes.CLOUD, center.field_72450_a, center.field_72448_b, center.field_72449_c, direction.field_72450_a * 5.0, direction.field_72448_b * 5.0, direction.field_72449_c * 5.0, new int[0]);
        }
    }

    private static class Instance
    extends AbstractSeal {
        public Instance(ISeal seal) {
            super(seal);
        }

        @Override
        public void addRequirements(BiConsumer<NatureType, Float> capacity, BiConsumer<NatureType, Float> consumption) {
            capacity.accept(NatureType.AIR, Float.valueOf(500.0f));
            consumption.accept(NatureType.AIR, Float.valueOf(100.0f));
        }

        @Override
        public void update() {
            SealPullRadial.moveEntities(this.seal, true, this::consumeEnergy);
        }
    }
}

