/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.seal;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import mod.crystals.api.NatureType;
import mod.crystals.api.seal.ISeal;
import mod.crystals.api.seal.ISealInstance;
import mod.crystals.api.seal.SealType;
import mod.crystals.seal.AbstractSeal;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class SealPullLinear
extends SealType {
    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public int getTint() {
        return NatureType.AIR.getColor();
    }

    @Override
    public SealType.Ingredient[][] createRecipe() {
        SealType.Ingredient wind = new SealType.Ingredient(NatureType.AIR);
        SealType.Ingredient pull = new SealType.Ingredient(NatureType.AIR, NatureType.VOID);
        return new SealType.Ingredient[][]{{null, wind, null}, {wind, pull, wind}, {null, wind, null}};
    }

    @Override
    public ISealInstance instantiate(ISeal seal) {
        return new Instance(seal);
    }

    public static void moveEntities(ISeal seal, boolean pull, float radius, BooleanSupplier consume) {
        EnumFacing face = seal.getFace();
        Vec3d dv = new Vec3d(face.func_176730_m());
        Vec3d center = new Vec3d((Vec3i)seal.getPos()).func_72441_c(0.5, 0.5, 0.5).func_178787_e(new Vec3d(face.func_176734_d().func_176730_m()).func_186678_a(0.5));
        List entities = seal.getWorld().func_72839_b(null, new AxisAlignedBB(seal.getPos()).func_72321_a(dv.field_72450_a * 10.0, dv.field_72448_b * 10.0, dv.field_72449_c * 10.0).func_72321_a(-(1.0 - dv.field_72450_a) * (double)radius, -(1.0 - dv.field_72448_b) * (double)radius, -(1.0 - dv.field_72449_c) * (double)radius).func_72321_a((1.0 - dv.field_72450_a) * (double)radius, (1.0 - dv.field_72448_b) * (double)radius, (1.0 - dv.field_72449_c) * (double)radius));
        for (Entity entity : entities) {
            Vec3d ePos = entity.func_174791_d();
            Vec3d dif = ePos.func_178788_d(center);
            if ((dif = dif.func_178786_a(dif.field_72450_a * Math.abs(dv.field_72450_a), dif.field_72448_b * Math.abs(dv.field_72448_b), dif.field_72449_c * Math.abs(dv.field_72449_c))).func_189985_c() > (double)(radius * radius)) continue;
            if (!consume.getAsBoolean()) break;
            dif = ePos.func_178788_d(center).func_186678_a(pull ? -1.0 : 1.0);
            Vec3d dir = pull ? (dif.func_189985_c() > 1.0 ? dif.func_72432_b() : dif).func_186678_a(0.1) : dv.func_72432_b().func_186678_a(0.1);
            entity.field_70159_w += dir.field_72450_a;
            entity.field_70181_x += dir.field_72448_b + 0.02;
            entity.field_70179_y += dir.field_72449_c;
        }
    }

    private static class Instance
    extends AbstractSeal {
        public Instance(ISeal seal) {
            super(seal);
        }

        @Override
        public void addRequirements(BiConsumer<NatureType, Float> capacity, BiConsumer<NatureType, Float> consumption) {
            capacity.accept(NatureType.AIR, Float.valueOf(200.0f));
            consumption.accept(NatureType.AIR, Float.valueOf(50.0f));
        }

        @Override
        public void update() {
            SealPullLinear.moveEntities(this.seal, true, 1.5f, this::consumeEnergy);
        }
    }
}

