/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.seal;

import gnu.trove.map.TObjectFloatMap;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import mod.crystals.CrystalsMod;
import mod.crystals.api.NatureType;
import mod.crystals.api.seal.ISealInstance;
import mod.crystals.network.PacketSealFX;
import mod.crystals.tile.TileCrystalBase;
import mod.crystals.tile.TileSeal;
import mod.crystals.util.ResonantUtils;
import mod.crystals.util.SimpleManager;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SealManager
extends SimpleManager {
    private Set<TileSeal> seals = new HashSet<TileSeal>();
    private Set<TileSeal> nextSeals = this.seals;

    public SealManager(World world) {
        super(world);
    }

    public void add(TileSeal seal) {
        if (this.nextSeals == this.seals) {
            this.nextSeals = new HashSet<TileSeal>(this.seals);
        }
        this.nextSeals.add(seal);
    }

    public void remove(TileSeal seal) {
        if (this.nextSeals == this.seals) {
            this.nextSeals = new HashSet<TileSeal>(this.seals);
        }
        this.nextSeals.remove((Object)seal);
    }

    @Override
    protected void update(World world) {
        if (world.field_72995_K) {
            return;
        }
        HashMap<TileCrystalBase, TObjectFloatMap> natures = new HashMap<TileCrystalBase, TObjectFloatMap>();
        for (TileSeal seal : this.seals) {
            if (seal.getSeal() == null) continue;
            ISealInstance instance = seal.getSeal();
            for (TileCrystalBase crystal : this.findCrystals(seal)) {
                TObjectFloatMap cNatures = natures.computeIfAbsent(crystal, TileCrystalBase::visit);
                cNatures.forEachEntry((type, max) -> {
                    float accepted = instance.getAccepted((NatureType)((Object)type));
                    if (accepted == 0.0f) {
                        return true;
                    }
                    float amt = Math.min(accepted, max);
                    instance.addNature((NatureType)((Object)type), amt);
                    this.spawnParticles(seal, crystal, (NatureType)((Object)type), amt);
                    return true;
                });
            }
        }
        this.seals = this.nextSeals;
    }

    private void spawnParticles(TileSeal seal, TileCrystalBase crystal, NatureType type, float amt) {
        Color color = new Color(type.getColor());
        World world = seal.func_145831_w();
        int count = Math.min(1 + (int)Math.sqrt(amt), 5);
        Vec3d center = new Vec3d((Vec3i)seal.func_174877_v()).func_72441_c(0.5, 0.5, 0.5).func_178787_e(new Vec3d(seal.getFace().func_176734_d().func_176730_m()).func_186678_a(0.5));
        Vec3d cPos = crystal.getPosition(0.0f, true);
        Vec3d vec = center.func_178788_d(cPos);
        Vec3d mot = vec.func_72432_b().func_186678_a(0.1);
        CrystalsMod.net.sendToAllAround((IMessage)PacketSealFX.create(count, cPos, mot, color), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), cPos.field_72450_a, cPos.field_72448_b, cPos.field_72449_c, 32.0));
    }

    private Iterable<TileCrystalBase> findCrystals(TileSeal seal) {
        return ResonantUtils.getCrystalsAround(seal.func_145831_w(), seal.func_174877_v(), 5.0f, null);
    }
}

