/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.seal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.BiConsumer;
import mod.crystals.CrystalsMod;
import mod.crystals.api.NatureType;
import mod.crystals.api.seal.ISeal;
import mod.crystals.api.seal.ISealInstance;
import mod.crystals.api.seal.SealType;
import mod.crystals.client.particle.ParticleType;
import mod.crystals.seal.AbstractSeal;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class SealLocalRain
extends SealType {
    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public int getTint() {
        return NatureType.WATER.getColor();
    }

    @Override
    public SealType.Ingredient[][] createRecipe() {
        SealType.Ingredient rain = new SealType.Ingredient(NatureType.WATER, NatureType.AIR);
        return new SealType.Ingredient[][]{{rain, rain, rain}, {rain, rain, rain}, {rain, rain, rain}};
    }

    @Override
    public ISealInstance instantiate(ISeal seal) {
        return new Instance(seal);
    }

    private static class Instance
    extends AbstractSeal {
        private final ISeal seal;

        public Instance(ISeal seal) {
            super(seal);
            this.seal = seal;
        }

        @Override
        public void addRequirements(BiConsumer<NatureType, Float> capacity, BiConsumer<NatureType, Float> consumption) {
            capacity.accept(NatureType.WATER, Float.valueOf(100.0f));
            consumption.accept(NatureType.WATER, Float.valueOf(10.0f));
        }

        @Override
        public void update() {
            if (!this.consumeEnergy()) {
                return;
            }
            World world = this.seal.getWorld();
            EnumFacing face = this.seal.getFace();
            Vec3d center = new Vec3d((Vec3i)this.seal.getPos()).func_72441_c(0.5, 0.5, 0.5).func_178787_e(new Vec3d(face.func_176734_d().func_176730_m()).func_186678_a(0.5));
            Vec3d front = new Vec3d(face.func_176730_m());
            Vec3d perp1 = new Vec3d(front.field_72448_b, front.field_72449_c, front.field_72450_a);
            Vec3d perp2 = new Vec3d(front.field_72449_c, front.field_72450_a, front.field_72448_b);
            this.spawnParticles(world, face, center, front, perp1, perp2);
            this.simulateRain(world, this.seal.getPos(), face, center, front, perp1, perp2);
        }

        private void spawnParticles(World world, EnumFacing face, Vec3d center, Vec3d front, Vec3d perp1, Vec3d perp2) {
            for (int i = -13; i <= 13; ++i) {
                for (int j = -13; j <= 13; ++j) {
                    if (i * i + j * j > 169 || Math.random() > 0.015625) continue;
                    double speed = (0.75 + 0.25 * Math.random()) * 0.125;
                    double off = Math.random() * 0.125;
                    Vec3d pos = center.func_178787_e(perp1.func_186678_a((double)((float)i / 10.0f))).func_178787_e(perp2.func_186678_a((double)((float)j / 10.0f))).func_178787_e(front.func_186678_a(off));
                    if (face.func_176740_k() != EnumFacing.Axis.Y) {
                        int h = face.func_176740_k() == EnumFacing.Axis.X ? j : i;
                        speed += (0.75 + (double)((float)(26 - h) / 26.0f)) * 0.25;
                    }
                    CrystalsMod.proxy.spawnParticle(world, ParticleType.RAIN, ParticleType.posVelocity(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, front.field_72450_a * speed, front.field_72448_b * speed, front.field_72449_c * speed));
                }
            }
        }

        private void simulateRain(World world, BlockPos sealPos, EnumFacing face, Vec3d center, Vec3d front, Vec3d perp1, Vec3d perp2) {
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            visited.add(sealPos);
            for (int i = -3; i <= 3; ++i) {
                for (int j = -3; j <= 3; ++j) {
                    BlockPos pos;
                    Vec3d start;
                    if (i * i + j * j > 9) continue;
                    Vec3d current = start = center.func_178787_e(perp1.func_186678_a((double)((float)i / 3.0f))).func_178787_e(perp2.func_186678_a((double)((float)j / 3.0f)));
                    double speed = 0.109375;
                    if (face.func_176740_k() != EnumFacing.Axis.Y) {
                        int h = face.func_176740_k() == EnumFacing.Axis.X ? j : i;
                        speed += (1.0 + (6.5 - (double)h) / 6.0) * 0.25;
                    }
                    Vec3d vel = front.func_186678_a(speed);
                    for (int k = 0; !(k >= 50 || visited.add(pos = new BlockPos(current)) && (this.tryWater(world, pos, true) || this.isSolid(world, pos, current))); ++k) {
                        double vx = Math.copySign(Math.max(0.0, Math.abs(vel.field_72450_a) - 0.05), vel.field_72450_a);
                        double vy = (vel.field_72448_b - 0.06) * 0.98;
                        double vz = Math.copySign(Math.max(0.0, Math.abs(vel.field_72449_c) - 0.05), vel.field_72449_c);
                        vel = new Vec3d(vx, vy, vz);
                        current = current.func_178787_e(vel);
                    }
                }
            }
        }

        private boolean isSolid(World world, BlockPos pos, Vec3d current) {
            ArrayList list = new ArrayList();
            world.func_180495_p(pos).func_185908_a(world, pos, Block.field_185505_j.func_186670_a(pos), list, null, false);
            for (AxisAlignedBB aabb : list) {
                if (!aabb.func_72318_a(current)) continue;
                return true;
            }
            return false;
        }

        private boolean tryWater(World world, BlockPos pos, boolean firstPass) {
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof BlockFarmland) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(Math.min((Integer)state.func_177229_b((IProperty)BlockFarmland.field_176531_a) + 2, 7))));
                return true;
            }
            return firstPass && this.tryWater(world, pos.func_177977_b(), false);
        }
    }
}

