/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.seal;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import mod.crystals.api.NatureType;
import mod.crystals.api.seal.ISeal;
import mod.crystals.api.seal.ISealInstance;
import mod.crystals.api.seal.SealType;
import mod.crystals.seal.AbstractSeal;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class SealHarvest
extends SealType {
    private static final List<Pair<BlockMatcher, HarvestOp>> harvestLogic = new ArrayList<Pair<BlockMatcher, HarvestOp>>();

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public int getTint() {
        return NatureType.EARTH.getColor();
    }

    @Override
    public SealType.Ingredient[][] createRecipe() {
        SealType.Ingredient i = new SealType.Ingredient(NatureType.DISTORTED, NatureType.EARTH);
        return new SealType.Ingredient[][]{{i, i, i}, {i, i, i}, {i, i, i}};
    }

    @Override
    public ISealInstance instantiate(ISeal seal) {
        return new Instance(seal);
    }

    public static void addHarvestOverride(BlockMatcher matcher, HarvestOp op) {
        harvestLogic.add(0, (Pair<BlockMatcher, HarvestOp>)Pair.of((Object)matcher, (Object)op));
    }

    static {
        SealHarvest.addHarvestOverride((world, state, pos) -> {
            Block block = state.func_177230_c();
            return block instanceof IGrowable && !((IGrowable)block).func_176473_a(world, pos, state, world.field_72995_K);
        }, (world, state, pos) -> {
            Block block = state.func_177230_c();
            ItemStack item = block.getPickBlock(state, null, world, pos, null);
            NonNullList items = NonNullList.func_191196_a();
            block.getDrops(items, (IBlockAccess)world, pos, state, 0);
            Optional<ItemStack> seedItem = items.stream().filter(it1 -> ItemStack.func_179545_c((ItemStack)it1, (ItemStack)item)).findAny();
            world.func_175656_a(pos, state.func_177230_c().func_176223_P());
            seedItem.ifPresent(it -> it.func_190918_g(1));
            items.forEach(it -> Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)it));
            return true;
        });
        SealHarvest.addHarvestOverride((world, state, pos) -> {
            Block block = state.func_177230_c();
            return block instanceof IGrowable && block instanceof BlockStem;
        }, (world, state, pos) -> false);
        SealHarvest.addHarvestOverride((world, state, pos) -> {
            Block block = state.func_177230_c();
            return block instanceof BlockMelon || block instanceof BlockPumpkin;
        }, (world, state, pos) -> {
            state.func_177230_c().func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
            return true;
        });
    }

    @FunctionalInterface
    public static interface HarvestOp {
        public boolean harvest(World var1, IBlockState var2, BlockPos var3);
    }

    @FunctionalInterface
    public static interface BlockMatcher {
        public boolean matches(World var1, IBlockState var2, BlockPos var3);
    }

    private static class Instance
    extends AbstractSeal {
        private final ISeal seal;
        private int cooldown = 80;

        public Instance(ISeal seal) {
            super(seal);
            this.seal = seal;
        }

        @Override
        public void addRequirements(BiConsumer<NatureType, Float> capacity, BiConsumer<NatureType, Float> consumption) {
            capacity.accept(NatureType.EARTH, Float.valueOf(100.0f));
            capacity.accept(NatureType.DISTORTED, Float.valueOf(50.0f));
            consumption.accept(NatureType.EARTH, Float.valueOf(50.0f));
            consumption.accept(NatureType.DISTORTED, Float.valueOf(25.0f));
        }

        @Override
        public void update() {
            World world = this.seal.getWorld();
            if (world.field_72995_K) {
                return;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return;
            }
            if (!this.consumeEnergy()) {
                return;
            }
            BlockPos pos = this.seal.getPos();
            BlockPos center = pos.func_177971_a((Vec3i)new BlockPos(new Vec3d(this.seal.getFace().func_176730_m()).func_186678_a(3.0)));
            block0: for (BlockPos it : BlockPos.func_177980_a((BlockPos)center.func_177982_a(-2, -1, -2), (BlockPos)center.func_177982_a(2, 1, 2))) {
                IBlockState state = world.func_180495_p(it);
                for (Pair pair : harvestLogic) {
                    if (!((BlockMatcher)pair.getLeft()).matches(world, state, it)) continue;
                    if (!((HarvestOp)pair.getRight()).harvest(world, state, it)) continue block0;
                    return;
                }
            }
            this.cooldown = 80;
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            super.writeToNBT(tag);
            tag.func_74774_a("c", (byte)this.cooldown);
            return tag;
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            super.readFromNBT(tag);
            this.cooldown = tag.func_74771_c("c") & 0xFF;
        }
    }
}

