/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.seal;

import java.util.function.BiConsumer;
import mod.crystals.api.NatureType;
import mod.crystals.api.seal.ISeal;
import mod.crystals.api.seal.ISealInstance;
import mod.crystals.api.seal.SealType;
import mod.crystals.seal.SealBreathInstance;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class SealFireBreath
extends SealType {
    private static final float RADIUS = 5.0f;

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public SealType.Ingredient[][] createRecipe() {
        SealType.Ingredient fire = new SealType.Ingredient(NatureType.AIR, NatureType.FIRE);
        SealType.Ingredient pushFire = new SealType.Ingredient(NatureType.AIR, NatureType.FIRE, NatureType.DISTORTED);
        return new SealType.Ingredient[][]{{null, fire, null}, {fire, pushFire, fire}, {null, fire, null}};
    }

    @Override
    public ISealInstance instantiate(ISeal seal) {
        return new Instance(seal);
    }

    private static class Instance
    extends SealBreathInstance {
        public Instance(ISeal seal) {
            super(seal, 5.0f);
        }

        @Override
        public void addRequirements(BiConsumer<NatureType, Float> capacity, BiConsumer<NatureType, Float> consumption) {
            capacity.accept(NatureType.FIRE, Float.valueOf(100.0f));
            capacity.accept(NatureType.AIR, Float.valueOf(50.0f));
            consumption.accept(NatureType.FIRE, Float.valueOf(25.0f));
            consumption.accept(NatureType.AIR, Float.valueOf(12.5f));
        }

        @Override
        public void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
            world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, vx, vy, vz, new int[0]);
        }

        @Override
        public void addEffect(EntityLivingBase entity) {
            entity.func_70015_d(1);
        }
    }
}

