/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.seal;

import mod.crystals.api.seal.ISeal;
import mod.crystals.seal.AbstractSeal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class SealBreathInstance
extends AbstractSeal {
    private final float radius;

    public SealBreathInstance(ISeal seal, float radius) {
        super(seal);
        this.radius = radius;
    }

    public abstract void spawnParticle(World var1, double var2, double var4, double var6, double var8, double var10, double var12);

    public abstract void addEffect(EntityLivingBase var1);

    @Override
    public void update() {
        EnumFacing face = this.seal.getFace().func_176734_d();
        AxisAlignedBB bounds = SealBreathInstance.getAreaInFront(this.seal, this.radius, false);
        Vec3d center = new Vec3d((Vec3i)this.seal.getPos()).func_72441_c(0.5, 0.5, 0.5).func_178787_e(new Vec3d(face.func_176730_m()).func_186678_a(0.5));
        for (Entity entity : this.seal.getWorld().func_72839_b(null, bounds)) {
            Vec3d ePos;
            if (!(entity instanceof EntityLivingBase) || (ePos = entity.func_174824_e(0.0f)).func_72436_e(center) > (double)(this.radius * this.radius)) continue;
            if (!this.consumeEnergy()) {
                return;
            }
            if (this.seal.getWorld().field_72995_K) {
                Vec3d dir = ePos.func_178788_d(center).func_186678_a(0.05);
                Vec3d up = new Vec3d(0.0, 1.0, 0.0);
                Vec3d side = dir.func_72432_b().func_72431_c(up).func_72432_b();
                for (int x = -3; x <= 3; ++x) {
                    for (int y = -3; y <= 3; ++y) {
                        if (x * x + y * y > 9) continue;
                        dir = ePos.func_178787_e(side.func_186678_a((double)((float)x / 6.0f)).func_178787_e(up.func_186678_a((double)((float)y / 6.0f)))).func_178788_d(center).func_186678_a(0.1);
                        Vec3d pos = center.func_178787_e(dir.func_186678_a(Math.random())).func_72441_c((Math.random() - 0.5) * 0.125, (Math.random() - 0.5) * 0.125, (Math.random() - 0.5) * 0.125);
                        this.spawnParticle(this.seal.getWorld(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
                    }
                }
            }
            this.addEffect((EntityLivingBase)entity);
        }
    }
}

