/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.seal;

import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.function.BiConsumer;
import mod.crystals.CrystalsMod;
import mod.crystals.api.NatureType;
import mod.crystals.api.seal.ISeal;
import mod.crystals.api.seal.ISealInstance;
import mod.crystals.init.CrystalsRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public abstract class AbstractSeal
implements ISealInstance {
    protected final TObjectFloatMap<NatureType> energy = new TObjectFloatHashMap();
    private final TObjectFloatMap<NatureType> capacity = new TObjectFloatHashMap();
    private final TObjectFloatMap<NatureType> consumption = new TObjectFloatHashMap();
    protected final ISeal seal;

    public AbstractSeal(ISeal seal) {
        this.seal = seal;
        this.addRequirements((arg_0, arg_1) -> this.capacity.put(arg_0, arg_1), (arg_0, arg_1) -> this.consumption.put(arg_0, arg_1));
    }

    @Override
    public float getAccepted(NatureType type) {
        if (!this.capacity.containsKey((Object)type)) {
            return 0.0f;
        }
        return this.capacity.get((Object)type) - this.energy.get((Object)type);
    }

    @Override
    public void addNature(NatureType type, float amount) {
        this.energy.adjustOrPutValue((Object)type, amount, amount);
        this.seal.sync();
    }

    public abstract void addRequirements(BiConsumer<NatureType, Float> var1, BiConsumer<NatureType, Float> var2);

    protected boolean consumeEnergy() {
        if (!this.consumption.forEachEntry((k, v) -> this.energy.get((Object)k) > v)) {
            return false;
        }
        if (!this.seal.getWorld().field_72995_K) {
            this.consumption.forEachEntry((k, v) -> {
                this.energy.adjustValue((Object)k, -v);
                return true;
            });
            this.seal.sync();
        }
        return true;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagCompound energyTag = new NBTTagCompound();
        tag.func_74782_a("energy", (NBTBase)energyTag);
        for (NatureType type : this.energy.keySet()) {
            float v = this.energy.get((Object)type);
            energyTag.func_74776_a(type.getRegistryName().toString(), v);
        }
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        NBTTagCompound energyTag = tag.func_74775_l("energy");
        this.energy.clear();
        for (String typeid : energyTag.func_150296_c()) {
            NatureType type = (NatureType)CrystalsRegistries.natureRegistry.getValue(new ResourceLocation(typeid));
            if (type == null) {
                CrystalsMod.instance.logger.warn("Invalid nature type " + typeid);
                continue;
            }
            this.energy.put((Object)type, energyTag.func_74760_g(typeid));
        }
    }

    @Override
    public void writeClientData(PacketBuffer buf) {
        buf.func_150787_b(this.energy.size());
        for (NatureType type : this.energy.keySet()) {
            buf.func_180714_a(type.getRegistryName().toString());
            buf.writeFloat(this.energy.get((Object)type));
        }
    }

    @Override
    public void readClientData(PacketBuffer buf) {
        this.energy.clear();
        int size = buf.func_150792_a();
        for (int i = 0; i < size; ++i) {
            String typeid = buf.func_150789_c(256);
            float v = buf.readFloat();
            NatureType type = (NatureType)CrystalsRegistries.natureRegistry.getValue(new ResourceLocation(typeid));
            if (type == null) continue;
            this.energy.put((Object)type, v);
        }
    }

    public static AxisAlignedBB getAreaInFront(ISeal seal, float radius, boolean extend) {
        EnumFacing face = seal.getFace().func_176734_d();
        AxisAlignedBB bounds = new AxisAlignedBB(seal.getPos());
        float depth = extend ? radius * 2.0f : radius;
        switch (face.func_176740_k()) {
            case X: {
                bounds = bounds.func_72321_a(0.0, (double)(-radius), (double)(-radius)).func_72321_a(0.0, (double)radius, (double)radius).func_72321_a(face.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? (double)depth : (double)(-depth), 0.0, 0.0);
                break;
            }
            case Y: {
                bounds = bounds.func_72321_a((double)(-radius), 0.0, (double)(-radius)).func_72321_a((double)radius, 0.0, (double)radius).func_72321_a(0.0, face.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? (double)depth : (double)(-depth), 0.0);
                break;
            }
            case Z: {
                bounds = bounds.func_72321_a((double)(-radius), (double)(-radius), 0.0).func_72321_a((double)radius, (double)radius, 0.0).func_72321_a(0.0, 0.0, face.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? (double)depth : (double)(-depth));
            }
        }
        return bounds;
    }
}

