/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.network;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import mod.crystals.CrystalsMod;
import mod.crystals.client.particle.ParticleType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSealFX
implements IMessage {
    public int count;
    public Vec3d cPos;
    public Vec3d mot;
    public Color color;

    public void fromBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        this.count = pb.func_150792_a();
        this.cPos = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.mot = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.color = new Color(buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        pb.func_150787_b(this.count);
        pb.writeDouble(this.cPos.field_72450_a);
        pb.writeDouble(this.cPos.field_72448_b);
        pb.writeDouble(this.cPos.field_72449_c);
        pb.writeDouble(this.mot.field_72450_a);
        pb.writeDouble(this.mot.field_72448_b);
        pb.writeDouble(this.mot.field_72449_c);
        pb.writeInt(this.color.getRGB());
    }

    public static PacketSealFX create(int count, Vec3d cPos, Vec3d mot, Color color) {
        PacketSealFX packet = new PacketSealFX();
        packet.count = count;
        packet.cPos = cPos;
        packet.mot = mot;
        packet.color = color;
        return packet;
    }

    public static class HandlerServer
    implements IMessageHandler<PacketSealFX, IMessage> {
        public IMessage onMessage(PacketSealFX message, MessageContext ctx) {
            return null;
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSealFX, IMessage> {
        public IMessage onMessage(PacketSealFX message, MessageContext ctx) {
            for (int i = 0; i < message.count; ++i) {
                CrystalsMod.proxy.spawnParticle((World)Minecraft.func_71410_x().field_71441_e, ParticleType.CIRCLE, ParticleType.posVelocityColor(message.cPos.field_72450_a, message.cPos.field_72448_b, message.cPos.field_72449_c, message.mot.field_72450_a, message.mot.field_72448_b, message.mot.field_72449_c, (float)message.color.getRed() / 255.0f, (float)message.color.getGreen() / 255.0f, (float)message.color.getBlue() / 255.0f));
            }
            return null;
        }
    }
}

