/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import mod.crystals.tile.TileSeal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.ArrayUtils;

public class PacketSealData
implements IMessage {
    public BlockPos pos;
    public byte[] data;

    public void fromBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        this.pos = pb.func_179259_c();
        this.data = pb.func_179251_a();
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        pb.func_179255_a(this.pos);
        pb.func_179250_a(this.data);
    }

    public static PacketSealData create(BlockPos pos, PacketBuffer data) {
        PacketSealData packet = new PacketSealData();
        packet.pos = pos;
        packet.data = ArrayUtils.subarray((byte[])data.array(), (int)data.arrayOffset(), (int)(data.writerIndex() + data.arrayOffset()));
        return packet;
    }

    public static class HandlerServer
    implements IMessageHandler<PacketSealData, IMessage> {
        public IMessage onMessage(PacketSealData message, MessageContext ctx) {
            return null;
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSealData, IMessage> {
        public IMessage onMessage(PacketSealData message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                throw new IllegalStateException("This packet is SERVER->CLIENT");
            }
            Minecraft mc = Minecraft.func_71410_x();
            WorldClient world = mc.field_71441_e;
            TileEntity te = world.func_175625_s(message.pos);
            if (te instanceof TileSeal) {
                ((TileSeal)te).getSeal().readClientData(new PacketBuffer(Unpooled.wrappedBuffer((byte[])message.data)));
            }
            return null;
        }
    }
}

