/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.item;

import gnu.trove.map.TObjectFloatMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.crystals.api.IResonant;
import mod.crystals.api.NatureType;
import mod.crystals.block.BlockCrystal;
import mod.crystals.environment.EnvironmentHandler;
import mod.crystals.init.CrystalsBlocks;
import mod.crystals.item.ItemBase;
import mod.crystals.tile.TileCrystal;
import mod.crystals.tile.TileCrystalBase;
import mod.crystals.util.ResonantUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class ItemTuningFork
extends ItemBase {
    private static final float ENVIRONMENT_TUNING_RATE = 0.005f;
    private static final float CRYSTAL_TUNING_RATE = 0.005f;

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.field_72995_K) {
            return;
        }
        if (!(entity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entity;
        int prevMeta = this.getMetadata(stack);
        EnumHand hand = null;
        if (player.func_184586_b(EnumHand.MAIN_HAND) == stack) {
            hand = EnumHand.MAIN_HAND;
        } else if (player.func_184586_b(EnumHand.OFF_HAND) == stack) {
            hand = EnumHand.OFF_HAND;
        }
        if (hand != null) {
            this.balanceFork(stack, world, (EntityPlayer)player);
            this.balanceCrystals(stack, world, (EntityPlayer)player);
            if (prevMeta != this.getMetadata(stack)) {
                player.func_71120_a(player.field_71069_bz);
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileCrystal)) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        IResonant resonantItem = (IResonant)stack.getCapability(IResonant.CAPABILITY, null);
        IResonant resonantCrystal = (IResonant)te.getCapability(IResonant.CAPABILITY, null);
        if (resonantCrystal == null) {
            return EnumActionResult.PASS;
        }
        float match = ResonantUtils.getMatch(resonantItem, resonantCrystal);
        if ((double)match < 0.8) {
            return EnumActionResult.FAIL;
        }
        ItemStack block = new ItemStack(CrystalsBlocks.crystal);
        NBTTagCompound tileData = new NBTTagCompound();
        te.func_189515_b(tileData);
        tileData.func_82580_o("wg");
        if (!block.func_77942_o()) {
            block.func_77982_d(new NBTTagCompound());
        }
        block.func_77978_p().func_74782_a("BlockEntityTag", (NBTBase)tileData);
        Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)block);
        BlockCrystal.dontDropItems = true;
        worldIn.func_175698_g(pos);
        BlockCrystal.dontDropItems = false;
        return EnumActionResult.SUCCESS;
    }

    private void balanceFork(ItemStack stack, World world, EntityPlayer player) {
        IResonant resonant = (IResonant)stack.getCapability(IResonant.CAPABILITY, null);
        if (resonant.getResonance() < 1.0f) {
            resonant.setResonance(Math.min(resonant.getResonance() + 0.005f, 1.0f));
        }
        TObjectFloatMap<NatureType> itemNatures = ResonantUtils.getNatureTypes(resonant, true);
        TObjectFloatMap<NatureType> worldNatures = EnvironmentHandler.INSTANCE.getNature(world, player.func_180425_c());
        ResonantUtils.balance(itemNatures, worldNatures, resonant.getResonance(), 1.0f, 0.005f);
        resonant.setNatureAmounts(itemNatures);
    }

    private void balanceCrystals(ItemStack stack, World world, EntityPlayer player) {
        IResonant resonant = (IResonant)stack.getCapability(IResonant.CAPABILITY, null);
        TObjectFloatMap<NatureType> itemNatures = ResonantUtils.getNatureTypes(resonant, true);
        float itemRes = resonant.getResonance();
        Set<TileCrystalBase> crystals = ResonantUtils.getCrystalsAround(world, player.func_180425_c(), 2.0f, null);
        for (TileCrystalBase te : crystals) {
            IResonant crystal = te.getCapability(IResonant.CAPABILITY, null);
            TObjectFloatMap<NatureType> crystalNatures = ResonantUtils.getNatureTypes(crystal, true);
            float crystalRes = crystal.getResonance();
            ResonantUtils.balance(itemNatures, crystalNatures, itemRes, crystalRes, 0.005f);
            float resDif = Math.min(Math.abs(crystalRes - itemRes), 0.01f) / 2.0f;
            if (crystalRes < itemRes) {
                crystal.setResonance(crystalRes + resDif);
                itemRes -= resDif;
            } else {
                crystal.setResonance(crystalRes - resDif);
                itemRes += resDif;
            }
            crystal.setNatureAmounts(crystalNatures);
        }
        resonant.setNatureAmounts(itemNatures);
    }

    public int getMetadata(ItemStack stack) {
        return (double)((IResonant)stack.getCapability(IResonant.CAPABILITY, null)).getResonance() > 0.2 ? 1 : 0;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        final IResonant resonant = (IResonant)IResonant.CAPABILITY.getDefaultInstance();
        return new ICapabilitySerializable(){

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == IResonant.CAPABILITY;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                return (T)(capability == IResonant.CAPABILITY ? resonant : null);
            }

            public NBTBase serializeNBT() {
                return IResonant.CAPABILITY.writeNBT((Object)resonant, null);
            }

            public void deserializeNBT(NBTBase nbt) {
                IResonant.CAPABILITY.readNBT((Object)resonant, null, nbt);
            }
        };
    }
}

