/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.init;

import mod.crystals.block.BlockCrystal;
import mod.crystals.block.BlockCrystalCreative;
import mod.crystals.block.BlockPost;
import mod.crystals.block.BlockSeal;
import mod.crystals.block.BlockSealExt;
import mod.crystals.block.BlockSlate;
import mod.crystals.init.CrystalsItems;
import mod.crystals.item.ItemSeal;
import mod.crystals.tile.TileCrystal;
import mod.crystals.tile.TileCrystalCreative;
import mod.crystals.tile.TileSeal;
import mod.crystals.tile.TileSealExt;
import mod.crystals.tile.TileSlate;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="crystals")
public class CrystalsBlocks {
    public static final Block crystal = new BlockCrystal();
    public static final Block crystal_creative = new BlockCrystalCreative();
    public static final Block post = new BlockPost();
    public static final Block slate = new BlockSlate();
    public static final Block seal = new BlockSeal();
    public static final Block seal_ext = new BlockSealExt();

    @SubscribeEvent
    public static void onBlockRegistration(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        CrystalsBlocks.registerBlock((IForgeRegistry<Block>)registry, crystal, TileCrystal.class, "crystal");
        CrystalsBlocks.registerBlock((IForgeRegistry<Block>)registry, crystal_creative, TileCrystalCreative.class, "crystal_creative");
        CrystalsBlocks.registerBlock((IForgeRegistry<Block>)registry, post, "post");
        CrystalsBlocks.registerBlock((IForgeRegistry<Block>)registry, slate, TileSlate.class, "slate");
        CrystalsBlocks.registerBlock((IForgeRegistry<Block>)registry, seal, TileSeal.class, "seal");
        CrystalsBlocks.registerBlock((IForgeRegistry<Block>)registry, seal_ext, TileSealExt.class, "seal_ext");
    }

    @SubscribeEvent
    public static void onItemRegistration(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        CrystalsBlocks.registerItem((IForgeRegistry<Item>)registry, crystal, "crystal");
        CrystalsBlocks.registerItem((IForgeRegistry<Item>)registry, crystal_creative, "crystal_creative");
        CrystalsBlocks.registerItem((IForgeRegistry<Item>)registry, post, "post");
        CrystalsBlocks.registerItem((IForgeRegistry<Item>)registry, slate, "slate");
        CrystalsItems.registerItem((IForgeRegistry<Item>)registry, (Item)new ItemSeal(seal), "seal");
    }

    private static ResourceLocation registerBlock(IForgeRegistry<Block> registry, Block block, String name) {
        ResourceLocation rl = new ResourceLocation("crystals", name);
        block.setRegistryName(rl);
        block.func_149663_c(rl.toString());
        registry.register((IForgeRegistryEntry)block);
        return rl;
    }

    private static void registerBlock(IForgeRegistry<Block> registry, Block block, Class<? extends TileEntity> teClass, String name) {
        ResourceLocation rl = CrystalsBlocks.registerBlock(registry, block, name);
        GameRegistry.registerTileEntity(teClass, (String)rl.toString());
    }

    private static ItemBlock registerItem(IForgeRegistry<Item> registry, Block block, String name) {
        ResourceLocation rl = new ResourceLocation("crystals", name);
        ItemBlock item = new ItemBlock(block);
        item.setRegistryName(rl);
        item.func_77655_b(rl.toString());
        registry.register((IForgeRegistryEntry)item);
        return item;
    }
}

