/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.environment;

import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.HashSet;
import java.util.Set;
import mod.crystals.api.IEnvironmentScanner;
import mod.crystals.api.NatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public enum EnvironmentHandler {
    INSTANCE;

    private final Set<IEnvironmentScanner> scanners = new HashSet<IEnvironmentScanner>();

    public void init(ASMDataTable table) {
        Set data = table.getAll(IEnvironmentScanner.Marker.class.getName());
        for (ASMDataTable.ASMData d : data) {
            try {
                Class<?> clazz = Class.forName(d.getClassName());
                IEnvironmentScanner scanner = (IEnvironmentScanner)clazz.newInstance();
                this.scanners.add(scanner);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public TObjectFloatMap<NatureType> getNature(World world, BlockPos pos) {
        TObjectFloatHashMap map = new TObjectFloatHashMap(16, 0.75f, 0.0f);
        for (IEnvironmentScanner iEnvironmentScanner : this.scanners) {
            iEnvironmentScanner.compute(world, pos, (arg_0, arg_1) -> EnvironmentHandler.lambda$getNature$0((TObjectFloatMap)map, arg_0, arg_1));
        }
        float sum = 0.0f;
        for (float amt2 : map.values()) {
            sum += amt2;
        }
        if (sum != 0.0f) {
            float f = sum;
            map.transformValues(amt -> amt / totalSum);
        }
        return map;
    }

    private static /* synthetic */ void lambda$getNature$0(TObjectFloatMap map, NatureType type, float amt) {
        map.adjustOrPutValue((Object)type, amt, amt);
    }
}

