/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.environment;

import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.Random;
import mod.crystals.api.IResonant;
import mod.crystals.api.NatureType;
import mod.crystals.block.BlockCrystal;
import mod.crystals.environment.BiomeEnvironmentScanner;
import mod.crystals.init.CrystalsBlocks;
import mod.crystals.tile.TileCrystal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class CrystalsWorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        GeneratorCrystals gen = new GeneratorCrystals();
        block0: for (int i = 0; i < 2; ++i) {
            for (int i1 = 0; i1 < 10; ++i1) {
                int x = chunkX * 16 + random.nextInt(16);
                int z = chunkZ * 16 + random.nextInt(16);
                int y = random.nextInt(128) + 12;
                BlockPos blockPos = new BlockPos(x, y, z);
                if (gen.func_180709_b(world, random, blockPos)) continue block0;
            }
        }
    }

    public static class GeneratorCrystals
    extends WorldGenMinable {
        public GeneratorCrystals() {
            super(CrystalsBlocks.crystal.func_176223_P(), 1);
        }

        public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
            float f = rand.nextFloat() * (float)Math.PI;
            double d0 = (float)(position.func_177958_n() + 8) + MathHelper.func_76126_a((float)f) * 1.0f / 8.0f;
            double d2 = (float)(position.func_177952_p() + 8) + MathHelper.func_76134_b((float)f) * 1.0f / 8.0f;
            double d4 = position.func_177956_o() + rand.nextInt(3) - 2;
            double d9 = rand.nextDouble() / 16.0;
            double d10 = 1.0 * d9 + 1.0;
            double d11 = 1.0 * d9 + 1.0;
            int j = MathHelper.func_76128_c((double)(d0 - d10 / 2.0));
            int k = MathHelper.func_76128_c((double)(d4 - d11 / 2.0));
            int l = MathHelper.func_76128_c((double)(d2 - d10 / 2.0));
            BlockPos blockpos = new BlockPos(j, k, l);
            IBlockState state = worldIn.func_180495_p(blockpos);
            EnumFacing attachSide = null;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos base = blockpos.func_177972_a(facing);
                if (!state.func_177230_c().func_176200_f((IBlockAccess)worldIn, blockpos) || !worldIn.func_180495_p(base).isSideSolid((IBlockAccess)worldIn, base, facing.func_176734_d())) continue;
                attachSide = facing;
                break;
            }
            if (attachSide == null) {
                return false;
            }
            if (!worldIn.func_175710_j(blockpos)) {
                worldIn.func_180501_a(blockpos, CrystalsBlocks.crystal.func_176223_P().func_177226_a(BlockCrystal.VARIANT, (Comparable)((Object)BlockCrystal.Variant.valueOf(attachSide.name()))), 2);
                TileCrystal te = (TileCrystal)worldIn.func_175625_s(blockpos);
                BiomeEnvironmentScanner bes = new BiomeEnvironmentScanner();
                IResonant resonant = te.getCapability(IResonant.CAPABILITY, null);
                TObjectFloatHashMap map = new TObjectFloatHashMap();
                bes.compute(worldIn, blockpos, (arg_0, arg_1) -> ((TObjectFloatMap)map).put(arg_0, arg_1));
                resonant.setNatureAmounts((TObjectFloatMap<NatureType>)map);
                resonant.setResonance(1.0f);
                return true;
            }
            return false;
        }
    }
}

