/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.environment;

import gnu.trove.map.hash.TObjectFloatHashMap;
import mod.crystals.api.IEnvironmentScanner;
import mod.crystals.api.NatureType;
import mod.crystals.capability.CapabilityLoadedCache;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

@IEnvironmentScanner.Marker
public class BlockEnvironmentScanner
implements IEnvironmentScanner {
    private static final int RADIUS = 5;
    private static final int MAX_DIST = 15;

    @Override
    public void compute(World world, BlockPos pos, NatureType.Acceptor acceptor) {
        TObjectFloatHashMap map = new TObjectFloatHashMap();
        CapabilityLoadedCache.LoadedChunks loaded = (CapabilityLoadedCache.LoadedChunks)world.getCapability(CapabilityLoadedCache.CAPABILITY, null);
        for (BlockPos blockPos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-5, -5, -5), (BlockPos)pos.func_177982_a(5, 5, 5))) {
            if (!loaded.isLoaded(blockPos)) continue;
            IBlockState state = world.func_180495_p(blockPos);
            Material mat = state.func_185904_a();
            BlockPos dist = blockPos.func_177973_b((Vec3i)pos);
            float weight = (float)(15 - Math.abs(dist.func_177958_n()) - Math.abs(dist.func_177956_o()) - Math.abs(dist.func_177952_p())) / 15.0f;
            if (mat == Material.field_151577_b || mat == Material.field_151578_c || mat == Material.field_151571_B || mat == Material.field_151573_f || mat == Material.field_151585_k || mat == Material.field_151584_j || mat == Material.field_151582_l || mat == Material.field_151575_d) {
                map.put((Object)NatureType.EARTH, 20.0f * weight);
                continue;
            }
            if (mat == Material.field_151576_e || mat == Material.field_151570_A) {
                map.put((Object)NatureType.EARTH, 15.0f * weight);
                map.put((Object)NatureType.DISTORTED, 5.0f * weight);
                continue;
            }
            if (mat == Material.field_151595_p) {
                map.put((Object)NatureType.AIR, 10.0f * weight);
                map.put((Object)NatureType.EARTH, 10.0f * weight);
                continue;
            }
            if (mat == Material.field_151588_w || mat == Material.field_151598_x || mat == Material.field_151597_y || mat == Material.field_151596_z) {
                map.put((Object)NatureType.AIR, 10.0f * weight);
                map.put((Object)NatureType.WATER, 10.0f * weight);
                continue;
            }
            if (mat == Material.field_151586_h) {
                map.put((Object)NatureType.WATER, 20.0f * weight);
                continue;
            }
            if (mat != Material.field_151587_i) continue;
            map.put((Object)NatureType.FIRE, 20.0f * weight);
        }
        float sum = 0.0f;
        for (float amt2 : map.values()) {
            sum += amt2;
        }
        if (sum != 0.0f) {
            float f = sum;
            map.forEachEntry((type, amt) -> {
                acceptor.accept((NatureType)((Object)((Object)type)), 80.0f * amt / totalSum);
                return true;
            });
        }
    }
}

