/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.crystal;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import javax.annotation.Nullable;
import mod.crystals.crystal.ILaserSource;
import mod.crystals.crystal.Ray;
import mod.crystals.util.CrystalsWorldEventListener;
import mod.crystals.util.SimpleManager;
import mod.crystals.util.UniqueQueue;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RayManager
extends SimpleManager {
    private Table<ILaserSource, ILaserSource, Ray> rays = HashBasedTable.create();
    private Table<ILaserSource, ILaserSource, Ray> nextRays = this.rays;
    private UniqueQueue<Ray> updated = UniqueQueue.concurrent();

    public RayManager(World world) {
        super(world);
    }

    public Ray addRay(ILaserSource from, ILaserSource to) {
        Ray ray = (Ray)this.nextRays.get((Object)from, (Object)to);
        if (ray != null) {
            return ray;
        }
        ray = (Ray)this.nextRays.get((Object)to, (Object)from);
        if (ray != null) {
            return ray.getOpposite();
        }
        ray = new Ray(from, to);
        if (this.nextRays == this.rays) {
            this.nextRays = HashBasedTable.create(this.rays);
        }
        this.nextRays.put((Object)from, (Object)to, (Object)ray);
        from.onConnect(to, ray);
        to.onConnect(from, ray.getOpposite());
        this.updated.add(ray);
        return ray;
    }

    public void removeAll(ILaserSource src) {
        this.nextRays.row((Object)src).forEach((to, ray) -> {
            src.onDisconnect((ILaserSource)to, (Ray)ray);
            to.onDisconnect(src, ray.getOpposite());
            this.updated.remove(ray);
        });
        this.nextRays.column((Object)src).forEach((to, ray) -> {
            src.onDisconnect((ILaserSource)to, (Ray)ray);
            to.onDisconnect(src, ray.getOpposite());
            this.updated.remove(ray);
        });
        if (this.nextRays == this.rays) {
            this.nextRays = HashBasedTable.create(this.rays);
        }
        this.nextRays.rowKeySet().remove(src);
        this.nextRays.columnKeySet().remove(src);
    }

    public Collection<Ray> getRays() {
        return this.rays.values();
    }

    @Override
    protected void update(World world) {
        while (!this.updated.isEmpty()) {
            this.updated.poll().update(world);
        }
        this.rays = this.nextRays;
    }

    public void updateRays(@Nullable BlockPos updatePos) {
        for (Ray ray : this.getRays()) {
            if (updatePos != null) {
                AxisAlignedBB updatePosBB = new AxisAlignedBB(updatePos);
                Vec3d start = ray.getStart(0.0f, false);
                Vec3d end = ray.getEnd(0.0f, false);
                AxisAlignedBB rayBox = new AxisAlignedBB(start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c);
                if (!updatePosBB.func_72326_a(rayBox)) continue;
            }
            this.updated.add(ray);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        e.getWorld().func_72954_a((IWorldEventListener)new CrystalsWorldEventListener(this));
    }
}

