/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.crystal;

import mod.crystals.crystal.ILaserSource;
import mod.crystals.util.RayTracer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Ray {
    private final ILaserSource start;
    private final ILaserSource end;
    private boolean hasLOS;
    private Ray opposite;

    public Ray(ILaserSource start, ILaserSource end) {
        this.start = start;
        this.end = end;
    }

    public void update(World world) {
        RayTraceResult hit = RayTracer.rayTraceLaser(world, this.getStart(0.0f, false), this.getEnd(0.0f, false));
        this.hasLOS = hit == null;
    }

    public boolean hasLineOfSight() {
        return this.hasLOS;
    }

    public ILaserSource getStart() {
        return this.start;
    }

    public ILaserSource getEnd() {
        return this.end;
    }

    public Vec3d getStart(float partialTicks, boolean render) {
        return this.start.getPosition(partialTicks, render);
    }

    public Vec3d getEnd(float partialTicks, boolean render) {
        return this.end.getPosition(partialTicks, render);
    }

    public Vec3d getStartColor(float partialTicks) {
        return this.start.getColor(partialTicks);
    }

    public Vec3d getEndColor(float partialTicks) {
        return this.end.getColor(partialTicks);
    }

    public Ray getOpposite() {
        if (this.opposite == null) {
            this.opposite = new OppositeRay(this);
            return this.opposite;
        }
        return this.opposite;
    }

    private static class OppositeRay
    extends Ray {
        private final Ray parent;

        private OppositeRay(Ray parent) {
            super(parent.end, parent.start);
            this.parent = parent;
        }

        @Override
        public void update(World world) {
            throw new IllegalStateException("This should not be called manually >_>");
        }

        @Override
        public boolean hasLineOfSight() {
            return this.parent.hasLineOfSight();
        }
    }
}

