/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.client.render;

import java.awt.Color;
import mod.crystals.api.seal.ISealInstance;
import mod.crystals.api.seal.SealType;
import mod.crystals.tile.TileSeal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class SealRenderer
extends TileEntitySpecialRenderer<TileSeal> {
    public void render(TileSeal te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te.getSeal() == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        switch (te.getFace()) {
            case DOWN: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case UP: {
                break;
            }
            case NORTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        if (te.getFace().func_176740_k() != EnumFacing.Axis.Y) {
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179137_b((double)0.0, (double)-0.498, (double)0.0);
        GlStateManager.func_179147_l();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179140_f();
        this.renderAll(te.getSealType(), te.getSeal(), (float)te.func_145831_w().func_82737_E() + partialTicks);
        GlStateManager.func_179145_e();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private void renderAll(SealType type, ISealInstance seal, double worldTime) {
        float rotSpeed;
        Color color = new Color(type.getTint());
        int size = type.getSize() * 2 + 1;
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        ResourceLocation path = type.getTextureLocation(SealType.TextureType.BASE);
        if (path != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(path);
            this.renderSeal(size, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        }
        if ((path = type.getTextureLocation(SealType.TextureType.OVERLAY)) != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(path);
            this.renderSeal(size, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        }
        if ((rotSpeed = type.getRotationSpeed()) != 0.0f) {
            float amt = 500.0f / rotSpeed;
            float time = (float)(worldTime % (double)amt) / amt;
            GlStateManager.func_179114_b((float)(360.0f * time), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if ((path = type.getTextureLocation(SealType.TextureType.GLOW_TRANSPARENT)) != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(path);
            this.renderSeal(size, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        }
        if ((path = type.getTextureLocation(SealType.TextureType.GLOW_BLACK)) != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(path);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            this.renderSeal(size, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        }
    }

    private void renderSeal(int size, float r, float g, float b, float a) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        float d = (float)size / 2.0f;
        buffer.func_181662_b((double)(-d), 0.0, (double)(-d)).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(-d), 0.0, (double)d).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)d, 0.0, (double)d).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)d, 0.0, (double)(-d)).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
    }
}

