/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.client.render;

import mod.crystals.capability.CapabilityRayManager;
import mod.crystals.crystal.Ray;
import mod.crystals.crystal.RayManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="crystals", value={Side.CLIENT})
public class LaserRenderer {
    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        RayManager manager = (RayManager)world.getCapability(CapabilityRayManager.CAPABILITY, null);
        Vec3d look = player.func_174824_e(event.getPartialTicks());
        GlStateManager.func_179147_l();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179103_j((int)7425);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("crystals", "textures/misc/laser_transparent.png"));
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        LaserRenderer.renderLasers(event, manager, look, false);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("crystals", "textures/misc/laser.png"));
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        LaserRenderer.renderLasers(event, manager, look, true);
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
    }

    private static void renderLasers(RenderWorldLastEvent event, RayManager manager, Vec3d look, boolean renderShimmer) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_178969_c(-TileEntityRendererDispatcher.field_147554_b, -TileEntityRendererDispatcher.field_147555_c, -TileEntityRendererDispatcher.field_147552_d);
        for (Ray ray : manager.getRays()) {
            if (!ray.hasLineOfSight()) continue;
            Vec3d start = ray.getStart(event.getPartialTicks(), true);
            Vec3d end = ray.getEnd(event.getPartialTicks(), true);
            Vec3d startColor = ray.getStartColor(event.getPartialTicks());
            Vec3d endColor = ray.getEndColor(event.getPartialTicks());
            LaserRenderer.drawLaser(buffer, start, end, look, startColor, endColor, renderShimmer);
        }
        buffer.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    private static void drawLaser(BufferBuilder buffer, Vec3d start, Vec3d end, Vec3d playerHead, Vec3d startColor, Vec3d endColor, boolean renderShimmer) {
        Vec3d dir = end.func_178788_d(start).func_72432_b();
        Vec3d startUp = dir.func_72431_c(start.func_178788_d(playerHead)).func_72432_b().func_186678_a(0.0625);
        Vec3d endUp = dir.func_72431_c(end.func_178788_d(playerHead)).func_72432_b().func_186678_a(0.0625);
        Vec3d ext1 = dir.func_186678_a(-startUp.func_72433_c());
        Vec3d ext2 = dir.func_186678_a(endUp.func_72433_c());
        if (renderShimmer) {
            buffer.func_181662_b(start.field_72450_a + startUp.field_72450_a, start.field_72448_b + startUp.field_72448_b, start.field_72449_c + startUp.field_72449_c).func_187315_a(0.0, 0.0).func_181666_a((float)startColor.field_72450_a, (float)startColor.field_72448_b, (float)startColor.field_72449_c, 0.5f).func_181675_d();
            buffer.func_181662_b(start.field_72450_a - startUp.field_72450_a, start.field_72448_b - startUp.field_72448_b, start.field_72449_c - startUp.field_72449_c).func_187315_a(0.0, 0.5).func_181666_a((float)startColor.field_72450_a, (float)startColor.field_72448_b, (float)startColor.field_72449_c, 0.5f).func_181675_d();
            buffer.func_181662_b(end.field_72450_a - endUp.field_72450_a, end.field_72448_b - endUp.field_72448_b, end.field_72449_c - endUp.field_72449_c).func_187315_a(0.5, 0.5).func_181666_a((float)endColor.field_72450_a, (float)endColor.field_72448_b, (float)endColor.field_72449_c, 0.5f).func_181675_d();
            buffer.func_181662_b(end.field_72450_a + endUp.field_72450_a, end.field_72448_b + endUp.field_72448_b, end.field_72449_c + endUp.field_72449_c).func_187315_a(0.5, 0.0).func_181666_a((float)endColor.field_72450_a, (float)endColor.field_72448_b, (float)endColor.field_72449_c, 0.5f).func_181675_d();
            buffer.func_181662_b(start.field_72450_a + startUp.field_72450_a, start.field_72448_b + startUp.field_72448_b, start.field_72449_c + startUp.field_72449_c).func_187315_a(0.0, 0.5).func_181666_a(1.0f, 1.0f, 1.0f, 0.2f).func_181675_d();
            buffer.func_181662_b(start.field_72450_a - startUp.field_72450_a, start.field_72448_b - startUp.field_72448_b, start.field_72449_c - startUp.field_72449_c).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.2f).func_181675_d();
            buffer.func_181662_b(end.field_72450_a - endUp.field_72450_a, end.field_72448_b - endUp.field_72448_b, end.field_72449_c - endUp.field_72449_c).func_187315_a(0.5, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.2f).func_181675_d();
            buffer.func_181662_b(end.field_72450_a + endUp.field_72450_a, end.field_72448_b + endUp.field_72448_b, end.field_72449_c + endUp.field_72449_c).func_187315_a(0.5, 0.5).func_181666_a(1.0f, 1.0f, 1.0f, 0.2f).func_181675_d();
        } else {
            buffer.func_181662_b(start.field_72450_a + startUp.field_72450_a, start.field_72448_b + startUp.field_72448_b, start.field_72449_c + startUp.field_72449_c).func_187315_a(0.0, 0.5).func_181666_a((float)startColor.field_72450_a, (float)startColor.field_72448_b, (float)startColor.field_72449_c, 0.5f).func_181675_d();
            buffer.func_181662_b(start.field_72450_a - startUp.field_72450_a, start.field_72448_b - startUp.field_72448_b, start.field_72449_c - startUp.field_72449_c).func_187315_a(0.0, 1.0).func_181666_a((float)startColor.field_72450_a, (float)startColor.field_72448_b, (float)startColor.field_72449_c, 0.5f).func_181675_d();
            buffer.func_181662_b(end.field_72450_a - endUp.field_72450_a, end.field_72448_b - endUp.field_72448_b, end.field_72449_c - endUp.field_72449_c).func_187315_a(0.5, 1.0).func_181666_a((float)endColor.field_72450_a, (float)endColor.field_72448_b, (float)endColor.field_72449_c, 0.5f).func_181675_d();
            buffer.func_181662_b(end.field_72450_a + endUp.field_72450_a, end.field_72448_b + endUp.field_72448_b, end.field_72449_c + endUp.field_72449_c).func_187315_a(0.5, 0.5).func_181666_a((float)endColor.field_72450_a, (float)endColor.field_72448_b, (float)endColor.field_72449_c, 0.5f).func_181675_d();
        }
    }
}

