/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import mod.crystals.client.WrappedModel;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import org.apache.commons.lang3.tuple.Pair;

public class TintWrapper
extends WrappedModel {
    private final Map<EnumFacing, List<BakedQuad>> quads = new IdentityHashMap<EnumFacing, List<BakedQuad>>();
    private final ItemOverrideList overrides = new ItemOverrideList(Collections.emptyList()){

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            return TintWrapper.this;
        }
    };

    public TintWrapper(IBakedModel parent) {
        super(parent);
    }

    @Override
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.quads.computeIfAbsent(side, s -> this.genQuads(state, side, rand));
    }

    private List<BakedQuad> genQuads(IBlockState state, EnumFacing side, long rand) {
        List<BakedQuad> originalQuads = super.func_188616_a(state, side, rand);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        GlowPipeline pipeline = new GlowPipeline();
        for (BakedQuad quad : originalQuads) {
            if (quad.func_178212_b()) {
                quads.add(quad);
                continue;
            }
            VertexFormat format = new VertexFormat(quad.getFormat()).func_181721_a(DefaultVertexFormats.field_181716_p);
            UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
            pipeline.setParent((IVertexConsumer)builder);
            quad.pipe((IVertexConsumer)pipeline);
            pipeline.setQuadTint(0);
            quads.add((BakedQuad)builder.build());
        }
        return quads;
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    @Override
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Pair<? extends IBakedModel, Matrix4f> pair = super.handlePerspective(cameraTransformType);
        if (pair != null) {
            return Pair.of((Object)this, (Object)pair.getValue());
        }
        return null;
    }

    private static class GlowPipeline
    implements IVertexConsumer {
        private IVertexConsumer parent;

        private GlowPipeline() {
        }

        public void setParent(IVertexConsumer parent) {
            this.parent = parent;
        }

        public VertexFormat getVertexFormat() {
            return this.parent.getVertexFormat();
        }

        public void setQuadTint(int tint) {
            this.parent.setQuadTint(tint);
        }

        public void setQuadOrientation(EnumFacing orientation) {
            this.parent.setQuadOrientation(orientation);
        }

        public void setApplyDiffuseLighting(boolean diffuse) {
            this.parent.setApplyDiffuseLighting(diffuse);
        }

        public void setTexture(TextureAtlasSprite texture) {
            this.parent.setTexture(texture);
        }

        public void put(int element, float ... data) {
            VertexFormatElement e = this.parent.getVertexFormat().func_177348_c(element);
            if (e == DefaultVertexFormats.field_181716_p) {
                this.parent.put(element, new float[]{0.0073243305f, 0.0073243305f});
                return;
            }
            this.parent.put(element, data);
        }
    }
}

