/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mod.crystals.CommonProxy;
import mod.crystals.api.IResonant;
import mod.crystals.block.BlockCrystalBase;
import mod.crystals.block.BlockSlate;
import mod.crystals.client.TintWrapper;
import mod.crystals.client.particle.ParticleCircle;
import mod.crystals.client.particle.ParticleRain;
import mod.crystals.client.particle.ParticleType;
import mod.crystals.client.render.FloatingCrystalRenderer;
import mod.crystals.client.render.SealRenderer;
import mod.crystals.init.CrystalsBlocks;
import mod.crystals.init.CrystalsItems;
import mod.crystals.item.ItemDust;
import mod.crystals.tile.TileCrystal;
import mod.crystals.tile.TileSeal;
import mod.crystals.util.IBlockAdvancedOutline;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    private Minecraft mc;
    private Map<ParticleType, BiFunction<World, ParticleType.ParticleParams, Particle>> particleGenerators = new HashMap<ParticleType, BiFunction<World, ParticleType.ParticleParams, Particle>>();

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        this.mc = Minecraft.func_71410_x();
        OBJLoader.INSTANCE.addDomain("crystals");
        this.registerParticle(ParticleType.RAIN, (world, p) -> new ParticleRain((World)world, p.position.field_72450_a, p.position.field_72448_b, p.position.field_72449_c, p.velocity.field_72450_a, p.velocity.field_72448_b, p.velocity.field_72449_c));
        this.registerParticle(ParticleType.CIRCLE, (world, p) -> new ParticleCircle((World)world, p.position.field_72450_a, p.position.field_72448_b, p.position.field_72449_c, p.velocity.field_72450_a, p.velocity.field_72448_b, p.velocity.field_72449_c, p.color.x, p.color.y, p.color.z));
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
        BlockColors blockColors = this.mc.func_184125_al();
        blockColors.func_186722_a((state, world, pos, index) -> {
            if (index == 1) {
                return 0xFFFFFF;
            }
            Integer color = (Integer)((IExtendedBlockState)state).getValue(BlockCrystalBase.COLOR);
            if (color == null) {
                return 0;
            }
            return color;
        }, new Block[]{CrystalsBlocks.crystal});
        blockColors.func_186722_a((state, world, pos, index) -> {
            if (index < 0 || index >= 4) {
                return 0;
            }
            Integer color = (Integer)((IExtendedBlockState)state).getValue(BlockSlate.COLORS[index]);
            if (color == null) {
                return 0;
            }
            return color;
        }, new Block[]{CrystalsBlocks.slate});
        ItemColors itemColors = this.mc.getItemColors();
        IResonant.Default tintResonant = (IResonant.Default)IResonant.CAPABILITY.getDefaultInstance();
        itemColors.func_186731_a((stack, index) -> {
            if (!stack.func_77942_o()) {
                return 0xFFFFFF;
            }
            IResonant.CAPABILITY.readNBT((Object)tintResonant, null, (NBTBase)stack.func_179543_a("BlockEntityTag").func_74775_l("rd"));
            return tintResonant.getColor();
        }, new Block[]{CrystalsBlocks.crystal});
        itemColors.func_186730_a((stack, index) -> ItemDust.getType(stack).getColor(), new Item[]{CrystalsItems.dust});
        ClientRegistry.bindTileEntitySpecialRenderer(TileCrystal.class, (TileEntitySpecialRenderer)new FloatingCrystalRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileSeal.class, (TileEntitySpecialRenderer)new SealRenderer());
    }

    @Override
    public <T extends ParticleType.ParticleParams> void spawnParticle(@Nonnull World world, @Nonnull ParticleType<T> type, @Nonnull T params) {
        super.spawnParticle(world, type, params);
        float chance = (float)(3 - Minecraft.func_71410_x().field_71474_y.field_74362_aa) / 3.0f;
        if (world.field_73012_v.nextFloat() > chance) {
            return;
        }
        Optional.ofNullable(this.particleGenerators.get(type)).map(it -> (Particle)it.apply(world, params)).ifPresent(arg_0 -> ((ParticleManager)this.mc.field_71452_i).func_78873_a(arg_0));
    }

    @SubscribeEvent
    public void onModelRegister(ModelRegistryEvent event) {
        this.addModel(CrystalsBlocks.crystal, 0, "inventory");
        this.addModel(CrystalsBlocks.crystal_creative, 0, "inventory");
        this.addModel(CrystalsBlocks.slate, 0, "inventory");
        this.addModel(CrystalsBlocks.post, 0, "inventory");
        this.addModel(CrystalsBlocks.seal, 0, "inventory");
        this.addItemModel(CrystalsItems.tuning_fork, 0, "tuning_fork");
        this.addItemModel(CrystalsItems.tuning_fork, 1, "tuning_fork_vibrating");
        this.addModel(CrystalsItems.dust, 0, "inventory");
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        this.wrap(event, new ModelResourceLocation(CrystalsBlocks.crystal.getRegistryName(), "variant=floating"), TintWrapper::new);
        this.wrap(event, new ModelResourceLocation(CrystalsBlocks.crystal.getRegistryName(), "variant=down"), TintWrapper::new);
        this.wrap(event, new ModelResourceLocation(CrystalsBlocks.crystal.getRegistryName(), "variant=up"), TintWrapper::new);
        this.wrap(event, new ModelResourceLocation(CrystalsBlocks.crystal.getRegistryName(), "variant=north"), TintWrapper::new);
        this.wrap(event, new ModelResourceLocation(CrystalsBlocks.crystal.getRegistryName(), "variant=south"), TintWrapper::new);
        this.wrap(event, new ModelResourceLocation(CrystalsBlocks.crystal.getRegistryName(), "variant=west"), TintWrapper::new);
        this.wrap(event, new ModelResourceLocation(CrystalsBlocks.crystal.getRegistryName(), "variant=east"), TintWrapper::new);
        this.wrap(event, new ModelResourceLocation(CrystalsBlocks.crystal.getRegistryName(), "inventory"), TintWrapper::new);
    }

    private void wrap(ModelBakeEvent event, ModelResourceLocation name, Function<IBakedModel, ? extends IBakedModel> wrapper) {
        IBakedModel model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)name);
        if (model == null) {
            return;
        }
        event.getModelRegistry().func_82595_a((Object)name, (Object)wrapper.apply(model));
    }

    private void addModel(Block block, int meta, String name) {
        this.addModel(Item.func_150898_a((Block)block), meta, name);
    }

    private void addModel(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), name));
    }

    private void addItemModel(Item item, int meta, String name) {
        ResourceLocation res = new ResourceLocation(item.getRegistryName().func_110624_b(), name);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(res, "inventory"));
    }

    @SubscribeEvent
    public void drawBlockOutline(DrawBlockHighlightEvent e) {
        BlockPos pos = e.getTarget().func_178782_a();
        if (pos == null) {
            return;
        }
        World world = e.getPlayer().field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IBlockAdvancedOutline) {
            ((IBlockAdvancedOutline)block).getOutlineBoxes(world, pos, state).stream().map(it -> it.func_186670_a(pos)).forEach(it -> this.drawSelectionBox(world, e.getPlayer(), pos, (AxisAlignedBB)it, e.getPartialTicks()));
            e.setCanceled(true);
        }
    }

    private void drawSelectionBox(World world, EntityPlayer player, BlockPos pos, AxisAlignedBB aabb, float partialTicks) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        IBlockState iblockstate = world.func_180495_p(pos);
        if (iblockstate.func_185904_a() != Material.field_151579_a && world.func_175723_af().func_177746_a(pos)) {
            double d3 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            double d4 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            double d5 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            RenderGlobal.func_189697_a((AxisAlignedBB)aabb.func_186662_g((double)0.002f).func_72317_d(-d3, -d4, -d5), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    private <T extends ParticleType.ParticleParams> void registerParticle(ParticleType<T> type, BiFunction<World, T, Particle> generator) {
        this.particleGenerators.put(type, generator);
    }
}

