/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.capability;

import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import mod.crystals.api.IResonant;
import mod.crystals.api.NatureType;
import mod.crystals.init.CrystalsRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class CapabilityResonant {

    public static class DefaultImpl
    implements IResonant.Default {
        private final TObjectFloatMap<NatureType> natures = new TObjectFloatHashMap(16, 0.75f, 0.0f);
        private float resonance = 0.0f;
        private final Set<Runnable> callbacks = new HashSet<Runnable>();

        public DefaultImpl() {
            this.natures.put((Object)NatureType.DISTORTED, 1.0f);
        }

        @Override
        public float getNatureAmount(NatureType natureType) {
            return this.natures.get((Object)natureType);
        }

        @Override
        public float getResonance() {
            return this.resonance;
        }

        @Override
        public TObjectFloatMap<NatureType> getNatureAmounts() {
            return this.natures;
        }

        @Override
        public int getColor() {
            float def;
            float red = def = 127.0f * (1.0f - this.resonance);
            float green = def;
            float blue = def;
            for (NatureType type : this.natures.keySet()) {
                float amt = this.natures.get((Object)type) * this.resonance;
                Color color = new Color(type.getColor());
                red += (float)color.getRed() * amt;
                green += (float)color.getGreen() * amt;
                blue += (float)color.getBlue() * amt;
            }
            return (int)Math.floor(red) << 16 | (int)Math.floor(green) << 8 | (int)Math.floor(blue);
        }

        @Override
        public void setNatureAmounts(TObjectFloatMap<NatureType> natureAmounts) {
            float sum = 0.0f;
            for (float amt2 : natureAmounts.values()) {
                if ((double)amt2 < 1.0E-4) continue;
                sum += amt2;
            }
            float totalSum = sum;
            this.natures.clear();
            natureAmounts.forEachEntry((type, amt) -> {
                if ((double)amt < 1.0E-4) {
                    return true;
                }
                this.natures.put((Object)type, amt / totalSum);
                return true;
            });
            this.callbacks.forEach(Runnable::run);
        }

        @Override
        public void setResonance(float res) {
            if ((double)res < 1.0E-4) {
                this.resonance = 0.0f;
                this.natures.clear();
                this.natures.put((Object)NatureType.DISTORTED, 1.0f);
                return;
            }
            this.resonance = res;
            this.callbacks.forEach(Runnable::run);
        }

        @Override
        public void addChangeListener(Runnable listener) {
            this.callbacks.add(listener);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("natures", this.natures).append("resonance", this.resonance).toString();
        }
    }

    public static class Storage
    implements Capability.IStorage<IResonant> {
        @Nullable
        public NBTBase writeNBT(Capability<IResonant> capability, IResonant obj, EnumFacing side) {
            if (!(obj instanceof DefaultImpl)) {
                throw new IllegalArgumentException("Cannot serialize an object of type " + obj.getClass().getName());
            }
            DefaultImpl impl = (DefaultImpl)obj;
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound natures = new NBTTagCompound();
            natures.func_74776_a(NatureType.DISTORTED.getRegistryName().toString(), 0.0f);
            impl.natures.forEachEntry((nature, amt) -> {
                natures.func_74776_a(nature.getRegistryName().toString(), amt);
                return true;
            });
            tag.func_74782_a("natures", (NBTBase)natures);
            tag.func_74776_a("resonance", impl.resonance);
            return tag;
        }

        public void readNBT(Capability<IResonant> capability, IResonant obj, EnumFacing side, NBTBase nbt) {
            if (!(obj instanceof DefaultImpl)) {
                throw new IllegalArgumentException("Cannot deserialize an object of type " + obj.getClass().getName());
            }
            DefaultImpl impl = (DefaultImpl)obj;
            NBTTagCompound tag = (NBTTagCompound)nbt;
            NBTTagCompound natures = tag.func_74775_l("natures");
            impl.natures.clear();
            for (ResourceLocation name : CrystalsRegistries.natureRegistry.getKeys()) {
                NatureType natureType = (NatureType)CrystalsRegistries.natureRegistry.getValue(name);
                float amt = natures.func_74760_g(name.toString());
                if ((double)amt < 1.0E-4) continue;
                impl.natures.put((Object)natureType, amt);
            }
            impl.resonance = tag.func_74760_g("resonance");
        }
    }
}

