/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.capability;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.crystals.util.SimpleManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="crystals")
public class CapabilityLoadedCache {
    private static final ResourceLocation NAME = new ResourceLocation("crystals", "loaded_chunk_cache");
    @CapabilityInject(value=LoadedChunks.class)
    public static final Capability<LoadedChunks> CAPABILITY = null;

    @SubscribeEvent
    public static void onCapabilityAttach(AttachCapabilitiesEvent<World> event) {
        final LoadedChunks storage = new LoadedChunks((World)event.getObject());
        event.addCapability(NAME, new ICapabilityProvider(){

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == CAPABILITY;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                return (T)(capability == CAPABILITY ? storage : null);
            }
        });
    }

    public static boolean isLoaded(World world, BlockPos pos) {
        return ((LoadedChunks)world.getCapability(CAPABILITY, null)).isLoaded(pos);
    }

    public static boolean isLoaded(World world, int x, int z) {
        return ((LoadedChunks)world.getCapability(CAPABILITY, null)).isLoaded(x, z);
    }

    public static class LoadedChunks
    extends SimpleManager {
        private static Map<ChunkPos, Boolean> loaded = new HashMap<ChunkPos, Boolean>();

        public LoadedChunks(World world) {
            super(world);
        }

        public boolean isLoaded(BlockPos pos) {
            World world = this.getWorld();
            if (world == null) {
                return false;
            }
            return loaded.computeIfAbsent(new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4), p -> world.func_175667_e(pos));
        }

        public boolean isLoaded(int x, int z) {
            World world = this.getWorld();
            if (world == null) {
                return false;
            }
            return loaded.computeIfAbsent(new ChunkPos(x, z), p -> world.func_175667_e(new BlockPos(x * 16, 0, z * 16)));
        }

        @Override
        protected void update(World world) {
            loaded = new HashMap<ChunkPos, Boolean>();
        }
    }

    public static class Storage
    implements Capability.IStorage<LoadedChunks> {
        @Nullable
        public NBTBase writeNBT(Capability<LoadedChunks> capability, LoadedChunks instance, EnumFacing side) {
            return null;
        }

        public void readNBT(Capability<LoadedChunks> capability, LoadedChunks instance, EnumFacing side, NBTBase nbt) {
        }
    }
}

