/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.block;

import javax.annotation.Nullable;
import mod.crystals.api.NatureType;
import mod.crystals.block.BlockBase;
import mod.crystals.init.CrystalsItems;
import mod.crystals.item.ItemDust;
import mod.crystals.tile.TileSlate;
import mod.crystals.util.UnlistedPropertyInt;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockSlate
extends BlockBase
implements ITileEntityProvider {
    public static final IProperty<Integer> DUST_COUNT = PropertyInteger.func_177719_a((String)"dusts", (int)0, (int)4);
    public static final IUnlistedProperty[] COLORS = new IUnlistedProperty[]{new UnlistedPropertyInt("color0"), new UnlistedPropertyInt("color1"), new UnlistedPropertyInt("color2"), new UnlistedPropertyInt("color3")};
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockSlate() {
        super(Material.field_151576_e);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return new TileSlate();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{DUST_COUNT}).add(COLORS).build();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof TileSlate)) {
            return state;
        }
        return state.func_177226_a(DUST_COUNT, (Comparable)Integer.valueOf(((TileSlate)te).getDustCount()));
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof TileSlate)) {
            return state;
        }
        int i = 0;
        for (NatureType type : ((TileSlate)te).getNatures()) {
            state = ((IExtendedBlockState)state).withProperty(COLORS[i++], (Object)type.getColor());
        }
        return state;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Override
    protected boolean isFull(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return false;
        }
        TileSlate te = (TileSlate)world.func_175625_s(pos);
        if (te == null) {
            return false;
        }
        if (stack.func_77973_b() == CrystalsItems.dust) {
            boolean canPut = te.putDust(ItemDust.getType(stack));
            if (!world.field_72995_K && canPut && !player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return canPut;
        }
        if (stack.func_77973_b() == CrystalsItems.tuning_fork) {
            return te.tryForm();
        }
        return false;
    }
}

