/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.block;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import mod.crystals.block.BlockBase;
import mod.crystals.block.BlockSeal;
import mod.crystals.init.CrystalsBlocks;
import mod.crystals.tile.TileSeal;
import mod.crystals.tile.TileSealExt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSealExt
extends BlockBase
implements ITileEntityProvider {
    public BlockSealExt() {
        super(Material.field_151576_e);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    @Override
    protected boolean isFull(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return new TileSealExt();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!BlockSealExt.checkIntegrity((IBlockAccess)world, pos)) {
            world.func_175698_g(pos);
            return;
        }
        if (!BlockSealExt.checkForSupport((IBlockAccess)world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        BlockPos sealPos = BlockSealExt.getSealPos((IBlockAccess)world, pos);
        IBlockState sealState = world.func_180495_p(Objects.requireNonNull(sealPos));
        return sealState.func_177230_c().getPickBlock(sealState, null, world, sealPos, player);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        BlockPos sealPos = BlockSealExt.getSealPos((IBlockAccess)world, pos);
        if (sealPos == null) {
            return super.func_185496_a(state, (IBlockAccess)world, pos);
        }
        IBlockState sealState = world.func_180495_p(sealPos);
        if (sealState.func_177230_c() != CrystalsBlocks.seal) {
            return super.func_180640_a(state, world, pos);
        }
        return sealState.func_185918_c(world, sealPos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        BlockPos sealPos = BlockSealExt.getSealPos(world, pos);
        if (sealPos == null) {
            return super.func_185496_a(state, world, pos);
        }
        IBlockState sealState = world.func_180495_p(sealPos);
        if (sealState.func_177230_c() != CrystalsBlocks.seal) {
            return super.func_185496_a(state, world, pos);
        }
        return sealState.func_185900_c(world, sealPos).func_186670_a(pos.func_177973_b((Vec3i)sealPos)).func_191500_a(field_185505_j);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return null;
    }

    @Nullable
    public static BlockPos getSealPos(IBlockAccess world, BlockPos pos) {
        TileEntity te;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockSeal) {
            return pos;
        }
        if (state.func_177230_c() instanceof BlockSealExt && (te = world.func_175625_s(pos)) instanceof TileSealExt) {
            return pos.func_177971_a(((TileSealExt)te).getOffset());
        }
        return null;
    }

    public static boolean checkIntegrity(IBlockAccess world, BlockPos pos) {
        BlockPos seal = BlockSealExt.getSealPos(world, pos);
        if (seal == null) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(seal);
        if (!(tileEntity instanceof TileSeal)) {
            return false;
        }
        TileSeal te = (TileSeal)tileEntity;
        for (BlockPos cp : te.getSealBox()) {
            if (Objects.equals(BlockSealExt.getSealPos(world, cp), seal)) continue;
            return false;
        }
        return true;
    }

    public static boolean canPlaceAt(IBlockAccess world, BlockPos pos, EnumFacing face, int radius) {
        for (BlockPos cp : BlockSealExt.getSealBounds(radius, face, pos)) {
            IBlockState state = world.func_180495_p(cp);
            if (!BlockSealExt.checkForSupport(world, cp, face)) {
                return false;
            }
            if (state.func_177230_c().func_176200_f(world, cp)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkForSupport(IBlockAccess world, BlockPos pos, EnumFacing face) {
        BlockPos support = pos.func_177972_a(face.func_176734_d());
        return world.func_180495_p(support).func_193401_d(world, support, face) == BlockFaceShape.SOLID;
    }

    public static boolean checkForSupport(IBlockAccess world, BlockPos pos) {
        EnumFacing f = (EnumFacing)world.func_180495_p(BlockSealExt.getSealPos(world, pos)).func_177229_b((IProperty)BlockDirectional.field_176387_N);
        return BlockSealExt.checkForSupport(world, pos, f);
    }

    public static void placeSealExt(World world, BlockPos pos) {
        Iterable<BlockPos> blocks = ((TileSeal)world.func_175625_s(pos)).getSealBox();
        for (BlockPos p : blocks) {
            if (Objects.equals(pos, p)) continue;
            world.func_175656_a(p, CrystalsBlocks.seal_ext.func_176223_P());
            ((TileSealExt)world.func_175625_s(p)).setOffset((Vec3i)pos.func_177973_b((Vec3i)p));
        }
    }

    public static Iterable<BlockPos> getSealBounds(int radius, EnumFacing face, BlockPos pos) {
        Vec3d front = new Vec3d(face.func_176730_m());
        Vec3d off1 = new Vec3d(front.field_72448_b, front.field_72449_c, front.field_72450_a);
        Vec3d off2 = new Vec3d(front.field_72449_c, front.field_72450_a, front.field_72448_b);
        BlockPos p1 = new BlockPos(new Vec3d((Vec3i)pos).func_178787_e(off1.func_186678_a((double)radius)).func_178787_e(off2.func_186678_a((double)radius)));
        BlockPos p2 = new BlockPos(new Vec3d((Vec3i)pos).func_178787_e(off1.func_186678_a((double)(-radius))).func_178787_e(off2.func_186678_a((double)(-radius))));
        return BlockPos.func_177980_a((BlockPos)p1, (BlockPos)p2);
    }
}

