/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.crystals.api.seal.SealType;
import mod.crystals.block.BlockBase;
import mod.crystals.block.BlockSealExt;
import mod.crystals.init.CrystalsBlocks;
import mod.crystals.init.CrystalsRegistries;
import mod.crystals.item.ItemSeal;
import mod.crystals.tile.TileSeal;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSeal
extends BlockBase
implements ITileEntityProvider {
    public BlockSeal() {
        super(Material.field_151576_e);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return new TileSeal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{BlockDirectional.field_176387_N}).build();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).ordinal();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)facing);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return null;
    }

    public boolean func_149703_v() {
        return true;
    }

    @Override
    protected boolean isFull(IBlockState state) {
        return false;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (SealType type : CrystalsRegistries.sealTypeRegistry) {
            items.add((Object)BlockSeal.createStack(type));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileSeal te = (TileSeal)world.func_175625_s(pos);
        return BlockSeal.createStack(te.getSealType());
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileSeal te = (TileSeal)world.func_175625_s(pos);
        drops.add((Object)BlockSeal.createStack(te.getSealType()));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        Vec3d front = new Vec3d(((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).func_176730_m());
        int size = BlockSeal.getSize(source, pos);
        Vec3d off1 = new Vec3d(front.field_72448_b, front.field_72449_c, front.field_72450_a).func_186678_a((double)size);
        Vec3d off2 = new Vec3d(front.field_72449_c, front.field_72450_a, front.field_72448_b).func_186678_a((double)size);
        Vec3d off3 = off1.func_178787_e(off2);
        Vec3d front1 = front.func_186678_a(0.9375);
        return field_185505_j.func_72314_b(Math.abs(off3.field_72450_a), Math.abs(off3.field_72448_b), Math.abs(off3.field_72449_c)).func_191195_a(front1.field_72450_a, front1.field_72448_b, front1.field_72449_c);
    }

    public static int getSize(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return 0;
        }
        if (!(te instanceof TileSeal)) {
            return 0;
        }
        TileSeal tile = (TileSeal)te;
        SealType sealType = tile.getSealType();
        if (sealType == null) {
            return 0;
        }
        return sealType.getSize();
    }

    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (advanced != ITooltipFlag.TooltipFlags.ADVANCED) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return;
        }
        if (!tag.func_74764_b("type")) {
            return;
        }
        tooltip.add("Seal type: " + tag.func_74779_i("type"));
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return super.func_176198_a(world, pos, side) && BlockSealExt.canPlaceAt((IBlockAccess)world, pos, side, ItemSeal.sealSize);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, blockIn, fromPos);
        if (!BlockSealExt.checkIntegrity((IBlockAccess)world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
            return;
        }
        if (!BlockSealExt.checkForSupport((IBlockAccess)world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return;
        }
        if (!tag.func_74764_b("type")) {
            return;
        }
        SealType type = (SealType)CrystalsRegistries.sealTypeRegistry.getValue(new ResourceLocation(tag.func_74779_i("type")));
        TileSeal te = (TileSeal)world.func_175625_s(pos);
        te.setSeal(type);
        BlockSealExt.placeSealExt(world, pos);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return false;
    }

    @Nonnull
    public static ItemStack createStack(@Nonnull SealType type) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("type", type.getRegistryName().toString());
        ItemStack stack = new ItemStack(CrystalsBlocks.seal);
        stack.func_77982_d(tag);
        return stack;
    }

    @Nullable
    public static SealType getType(@Nonnull ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return null;
        }
        if (!tag.func_74764_b("type")) {
            return null;
        }
        return (SealType)CrystalsRegistries.sealTypeRegistry.getValue(new ResourceLocation(tag.func_74779_i("type")));
    }
}

