/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.block;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mod.crystals.block.BlockBase;
import mod.crystals.util.IBlockAdvancedOutline;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class BlockPost
extends BlockBase
implements IBlockAdvancedOutline {
    private static final IProperty<PostComponent> COMPONENT = PropertyEnum.func_177709_a((String)"component", PostComponent.class);
    private static final IProperty<Boolean> NORTH = PropertyBool.func_177716_a((String)"north");
    private static final IProperty<Boolean> SOUTH = PropertyBool.func_177716_a((String)"south");
    private static final IProperty<Boolean> WEST = PropertyBool.func_177716_a((String)"west");
    private static final IProperty<Boolean> EAST = PropertyBool.func_177716_a((String)"east");
    private static final AxisAlignedBB MIDDLE_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static final AxisAlignedBB BOTTOM_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.75, 0.6875);
    private static final AxisAlignedBB SIDE_AABB = new AxisAlignedBB(0.375, 0.625, 0.375, 0.625, 1.0, 0.625);
    private static final List<AxisAlignedBB> EXT_AABB = Collections.unmodifiableList(Arrays.asList(new AxisAlignedBB(0.4375, 0.75, 0.625, 0.5625, 0.9375, 1.0), new AxisAlignedBB(0.0, 0.75, 0.4375, 0.375, 0.9375, 0.5625), new AxisAlignedBB(0.4375, 0.75, 0.0, 0.5625, 0.9375, 0.375), new AxisAlignedBB(0.625, 0.75, 0.4375, 1.0, 0.9375, 0.5625)));

    public BlockPost() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(4.0f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{COMPONENT, NORTH, SOUTH, WEST, EAST}).build();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(COMPONENT, (Comparable)((Object)PostComponent.VALUES[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((PostComponent)((Object)state.func_177229_b(COMPONENT))).ordinal();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (facing.func_176740_k() != EnumFacing.Axis.Y) {
            return this.func_176223_P().func_177226_a(COMPONENT, (Comparable)((Object)PostComponent.SIDE));
        }
        IBlockState below = world.func_180495_p(pos.func_177977_b());
        if (below.func_177230_c() == this) {
            return this.func_176223_P().func_177226_a(COMPONENT, (Comparable)((Object)PostComponent.TOP));
        }
        return this.func_176223_P().func_177226_a(COMPONENT, (Comparable)((Object)PostComponent.BOTTOM));
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return super.func_176198_a(worldIn, pos, side) && this.canStayAt(this.getStateForPlacement(worldIn, pos, side, 0.0f, 0.0f, 0.0f, 0, null, null), (IBlockAccess)worldIn, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (state.func_177229_b(COMPONENT) == PostComponent.BOTTOM) {
            return;
        }
        if (!this.canStayAt(state, (IBlockAccess)world, pos)) {
            state.func_177230_c().func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
            return;
        }
        this.updateState(state, world, pos);
    }

    public void updateState(IBlockState state, World world, BlockPos pos) {
        IBlockState above = world.func_180495_p(pos.func_177984_a());
        switch ((PostComponent)((Object)state.func_177229_b(COMPONENT))) {
            case BOTTOM: {
                break;
            }
            case MIDDLE: {
                if (above.func_177230_c() == this) break;
                world.func_175656_a(pos, state.func_177226_a(COMPONENT, (Comparable)((Object)PostComponent.TOP)));
                break;
            }
            case TOP: {
                if (above.func_177230_c() != this || !EnumSet.of(PostComponent.TOP, PostComponent.MIDDLE).contains(above.func_177229_b(COMPONENT))) break;
                world.func_175656_a(pos, state.func_177226_a(COMPONENT, (Comparable)((Object)PostComponent.MIDDLE)));
                break;
            }
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch ((PostComponent)((Object)state.func_177229_b(COMPONENT))) {
            case BOTTOM: {
                return state.func_177226_a(NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a(SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a(WEST, (Comparable)Boolean.valueOf(false)).func_177226_a(EAST, (Comparable)Boolean.valueOf(false));
            }
            case MIDDLE: 
            case TOP: {
                return state.func_177226_a(NORTH, (Comparable)Boolean.valueOf(this.isPostType(world, pos.func_177978_c(), PostComponent.SIDE))).func_177226_a(SOUTH, (Comparable)Boolean.valueOf(this.isPostType(world, pos.func_177968_d(), PostComponent.SIDE))).func_177226_a(WEST, (Comparable)Boolean.valueOf(this.isPostType(world, pos.func_177976_e(), PostComponent.SIDE))).func_177226_a(EAST, (Comparable)Boolean.valueOf(this.isPostType(world, pos.func_177974_f(), PostComponent.SIDE)));
            }
            case SIDE: {
                return state.func_177226_a(NORTH, (Comparable)Boolean.valueOf(this.isPostType(world, pos.func_177978_c(), PostComponent.MIDDLE, PostComponent.TOP))).func_177226_a(SOUTH, (Comparable)Boolean.valueOf(this.isPostType(world, pos.func_177968_d(), PostComponent.MIDDLE, PostComponent.TOP))).func_177226_a(WEST, (Comparable)Boolean.valueOf(this.isPostType(world, pos.func_177976_e(), PostComponent.MIDDLE, PostComponent.TOP))).func_177226_a(EAST, (Comparable)Boolean.valueOf(this.isPostType(world, pos.func_177974_f(), PostComponent.MIDDLE, PostComponent.TOP)));
            }
        }
        throw new IllegalStateException("something went very wrong!");
    }

    public boolean canStayAt(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch ((PostComponent)((Object)state.func_177229_b(COMPONENT))) {
            case BOTTOM: {
                return EnumSet.of(BlockFaceShape.CENTER, new BlockFaceShape[]{BlockFaceShape.CENTER_BIG, BlockFaceShape.CENTER_SMALL, BlockFaceShape.MIDDLE_POLE, BlockFaceShape.MIDDLE_POLE_THICK, BlockFaceShape.MIDDLE_POLE_THIN, BlockFaceShape.SOLID}).contains(world.func_180495_p(pos.func_177977_b()).func_193401_d(world, pos.func_177977_b(), EnumFacing.UP));
            }
            case MIDDLE: 
            case TOP: {
                return this.isPostType(world, pos.func_177977_b(), PostComponent.TOP, PostComponent.MIDDLE, PostComponent.BOTTOM);
            }
            case SIDE: {
                return Stream.of(this.isPostType(world, pos.func_177978_c(), PostComponent.TOP, PostComponent.MIDDLE), this.isPostType(world, pos.func_177968_d(), PostComponent.TOP, PostComponent.MIDDLE), this.isPostType(world, pos.func_177976_e(), PostComponent.TOP, PostComponent.MIDDLE), this.isPostType(world, pos.func_177974_f(), PostComponent.TOP, PostComponent.MIDDLE)).filter(it -> it).count() == 1L;
            }
        }
        throw new IllegalStateException("something went very wrong!");
    }

    public Collection<AxisAlignedBB> getBoundingBoxes(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_185899_b(world, pos);
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        switch ((PostComponent)((Object)state.func_177229_b(COMPONENT))) {
            case BOTTOM: {
                boxes.add(BOTTOM_AABB);
            }
            case SIDE: {
                boxes.add(SIDE_AABB);
                break;
            }
            case MIDDLE: 
            case TOP: {
                boxes.add(MIDDLE_AABB);
            }
        }
        if (((Boolean)state.func_177229_b(NORTH)).booleanValue()) {
            boxes.add(EXT_AABB.get(EnumFacing.NORTH.func_176736_b()));
        }
        if (((Boolean)state.func_177229_b(SOUTH)).booleanValue()) {
            boxes.add(EXT_AABB.get(EnumFacing.SOUTH.func_176736_b()));
        }
        if (((Boolean)state.func_177229_b(WEST)).booleanValue()) {
            boxes.add(EXT_AABB.get(EnumFacing.WEST.func_176736_b()));
        }
        if (((Boolean)state.func_177229_b(EAST)).booleanValue()) {
            boxes.add(EXT_AABB.get(EnumFacing.EAST.func_176736_b()));
        }
        return boxes;
    }

    @Override
    public Collection<AxisAlignedBB> getOutlineBoxes(World world, BlockPos pos, IBlockState state) {
        return this.getBoundingBoxes(state, (IBlockAccess)world, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getBoundingBoxes(state, source, pos).stream().reduce(null, (acc, a) -> acc == null ? a : acc.func_111270_a(a));
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        return this.getBoundingBoxes(blockState, (IBlockAccess)worldIn, pos).stream().map(it -> this.func_185503_a(pos, start, end, (AxisAlignedBB)it)).filter(Objects::nonNull).findAny().orElse(null);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        this.getBoundingBoxes(state, (IBlockAccess)world, pos).stream().map(it -> it.func_186670_a(pos)).filter(arg_0 -> ((AxisAlignedBB)entityBox).func_72326_a(arg_0)).forEach(collidingBoxes::add);
    }

    private boolean isPostType(IBlockAccess world, BlockPos pos, PostComponent ... validTypes) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == this && ArrayUtils.contains((Object[])validTypes, (Object)state.func_177229_b(COMPONENT));
    }

    @Override
    protected boolean isFull(IBlockState state) {
        return false;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP ? BlockFaceShape.CENTER : BlockFaceShape.UNDEFINED;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public static enum PostComponent implements IStringSerializable
    {
        BOTTOM,
        MIDDLE,
        TOP,
        SIDE;

        public static final PostComponent[] VALUES;

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            VALUES = PostComponent.values();
        }
    }
}

