/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.block;

import java.util.Random;
import javax.annotation.Nullable;
import mod.crystals.api.IResonant;
import mod.crystals.api.NatureType;
import mod.crystals.block.BlockCrystalBase;
import mod.crystals.init.CrystalsRegistries;
import mod.crystals.item.ItemDust;
import mod.crystals.tile.TileCrystal;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockCrystal
extends BlockCrystalBase {
    public static boolean dontDropItems = false;
    private static final AxisAlignedBB[] AABBS_GROUND = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.53125, 0.625), new AxisAlignedBB(0.375, 0.46875, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 0.53125), new AxisAlignedBB(0.375, 0.375, 0.46875, 0.625, 0.625, 1.0), new AxisAlignedBB(0.0, 0.375, 0.375, 0.53125, 0.625, 0.625), new AxisAlignedBB(0.46875, 0.375, 0.375, 1.0, 0.625, 0.625)};
    private static final AxisAlignedBB AABB_FLOATING = new AxisAlignedBB(0.40625, 0.234375, 0.40625, 0.59375, 0.765625, 0.59375);
    private static final AxisAlignedBB[] RT_AABBS_GROUND = new AxisAlignedBB[]{new AxisAlignedBB(0.4375, 0.125, 0.4375, 0.5625, 0.375, 0.5625), new AxisAlignedBB(0.4375, 0.625, 0.4375, 0.5625, 0.875, 0.5625), new AxisAlignedBB(0.4375, 0.4375, 0.125, 0.5625, 0.5625, 0.375), new AxisAlignedBB(0.4375, 0.4375, 0.625, 0.5625, 0.5625, 0.875), new AxisAlignedBB(0.125, 0.4375, 0.4375, 0.375, 0.5625, 0.5625), new AxisAlignedBB(0.625, 0.4375, 0.4375, 0.875, 0.5625, 0.5625)};
    private static final AxisAlignedBB RT_AABB_FLOATING = new AxisAlignedBB(0.4375, 0.375, 0.4375, 0.5625, 0.625, 0.5625);
    private static final AxisAlignedBB[] RT_AABBS_BASE = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.25, 0.625), new AxisAlignedBB(0.375, 0.75, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.0, 0.375, 0.375, 0.25, 0.625, 0.625), new AxisAlignedBB(0.75, 0.375, 0.375, 1.0, 0.625, 0.625), new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 0.25), new AxisAlignedBB(0.375, 0.375, 0.75, 0.625, 0.625, 1.0)};
    public static final IProperty<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);

    public BlockCrystal() {
        this.func_149711_c(1.5f);
        this.setHarvestLevel("pickaxe", 2);
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return new TileCrystal();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{VARIANT}).add(new IUnlistedProperty[]{BlockCrystalBase.COLOR}).build();
    }

    public int func_176201_c(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variant.VALUES[meta]));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        Variant variant = (Variant)((Object)state.func_177229_b(VARIANT));
        if (variant == Variant.FLOATING) {
            return AABB_FLOATING;
        }
        return AABBS_GROUND[variant.ordinal() - 1];
    }

    @Override
    public RayTraceResult laserRayTrace(World world, BlockPos pos, Vec3d start, Vec3d end) {
        Variant variant = (Variant)((Object)world.func_180495_p(pos).func_177229_b(VARIANT));
        AxisAlignedBB crystalAABB = variant == Variant.FLOATING ? RT_AABB_FLOATING : RT_AABBS_GROUND[variant.ordinal() - 1];
        RayTraceResult hit = crystalAABB.func_186670_a(pos).func_72327_a(start, end);
        if (variant != Variant.FLOATING && hit == null) {
            hit = RT_AABBS_BASE[variant.ordinal() - 1].func_186670_a(pos).func_72327_a(start, end);
        }
        return hit;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (dontDropItems) {
            return;
        }
        float dropScale = 5.0f;
        IResonant resonant = (IResonant)world.func_175625_s(pos).getCapability(IResonant.CAPABILITY, null);
        float resonance = resonant.getResonance();
        for (NatureType type : CrystalsRegistries.natureRegistry.getValuesCollection()) {
            float amt = resonant.getNatureAmount(type);
            int totalItems = Math.round(dropScale * resonance * amt);
            if (totalItems < 1) continue;
            ItemStack stack = ItemDust.getItemOfType(type);
            stack.func_190920_e(totalItems);
            BlockCrystal.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    @Override
    protected boolean isFull(IBlockState state) {
        return false;
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_175690_a(pos, (TileEntity)new TileCrystal());
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return super.func_176198_a(world, pos, side) && this.canStayAt(this.getStateForPlacement(world, pos, side, 0.0f, 0.0f, 0.0f, 0, null, null), (IBlockAccess)world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (state.func_177229_b(VARIANT) == Variant.FLOATING) {
            return;
        }
        if (!this.canStayAt(state, (IBlockAccess)world, pos)) {
            state.func_177230_c().func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public boolean canStayAt(IBlockState state, IBlockAccess world, BlockPos pos) {
        Variant variant = (Variant)((Object)state.func_177229_b(VARIANT));
        if (variant == Variant.FLOATING) {
            return true;
        }
        EnumFacing side = EnumFacing.func_82600_a((int)(variant.ordinal() - 1));
        BlockFaceShape shape = world.func_180495_p(pos.func_177972_a(side)).func_193401_d(world, pos, side.func_176734_d());
        return shape != BlockFaceShape.UNDEFINED && shape != BlockFaceShape.BOWL;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (placer == null || placer.func_70093_af()) {
            return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variant.VALUES[facing.func_176734_d().ordinal() + 1]));
        }
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variant.FLOATING));
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return state.func_177229_b(VARIANT) != Variant.FLOATING && super.canRenderInLayer(state, layer);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        CrystalsRegistries.natureRegistry.getValuesCollection().stream().map(this::getPureCrystal).forEach(arg_0 -> items.add(arg_0));
    }

    private ItemStack getPureCrystal(NatureType type) {
        ItemStack stack = new ItemStack((Block)this);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_151001_c("Crystal (" + type.getRegistryName() + ")");
        NBTTagCompound tag = stack.func_77978_p();
        NBTTagCompound teData = new NBTTagCompound();
        NBTTagCompound tag_rd = new NBTTagCompound();
        NBTTagCompound tag_natures = new NBTTagCompound();
        tag.func_74782_a("BlockEntityTag", (NBTBase)teData);
        teData.func_74782_a("rd", (NBTBase)tag_rd);
        tag_rd.func_74782_a("natures", (NBTBase)tag_natures);
        tag_rd.func_74776_a("resonance", 1.0f);
        tag_natures.func_74776_a(NatureType.DISTORTED.getRegistryName().toString(), 0.0f);
        tag_natures.func_74776_a(type.getRegistryName().toString(), 1.0f);
        return stack;
    }

    public static enum Variant implements IStringSerializable
    {
        FLOATING,
        DOWN,
        UP,
        NORTH,
        SOUTH,
        WEST,
        EAST;

        public static final Variant[] VALUES;

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            VALUES = Variant.values();
        }
    }
}

